/*
 * Decompiled with CFR 0.152.
 */
package lucie.deathtaxes.entity.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lucie.deathtaxes.entity.Scavenger;
import lucie.deathtaxes.registry.AttachmentTypeRegistry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ambient.Bat;

public class DramaticEntrance
extends Behavior<Scavenger> {
    public DramaticEntrance() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.DANCING, (Object)MemoryStatus.VALUE_PRESENT), Integer.MAX_VALUE);
    }

    protected boolean canStillUse(@Nonnull ServerLevel level, @Nonnull Scavenger entity, long gameTime) {
        return entity.getBrain().getMemory(MemoryModuleType.DANCING).isPresent() && entity.hasEffect(MobEffects.INVISIBILITY) && entity.tickCount < 128;
    }

    protected void start(@Nonnull ServerLevel level, @Nonnull Scavenger entity, long gameTime) {
        entity.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 120, 0));
    }

    protected void stop(@Nonnull ServerLevel level, @Nonnull Scavenger entity, long gameTime) {
        super.stop(level, (LivingEntity)entity, gameTime);
        entity.getBrain().eraseMemory(MemoryModuleType.DANCING);
        entity.setInvisible(false);
        level.broadcastEntityEvent((Entity)entity, (byte)24);
        int i = 0;
        while (i < 2) {
            int index = i++;
            Optional.ofNullable((Bat)EntityType.BAT.spawn(level.getLevel(), entity.blockPosition().above(), MobSpawnType.TRIGGERED)).ifPresent(bat -> {
                bat.setData(AttachmentTypeRegistry.DESPAWN_TIME.get(), (Object)(gameTime + 120L + (long)(10 * index)));
                bat.restrictTo(entity.blockPosition(), 16);
            });
        }
    }

    protected boolean timedOut(long gameTime) {
        return false;
    }
}

