/*
 * Decompiled with CFR 0.152.
 */
package lucie.deathtaxes.entity.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import lucie.deathtaxes.entity.Scavenger;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.player.Player;

public class FollowTradingPlayer
extends Behavior<Scavenger> {
    public FollowTradingPlayer() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED), Integer.MAX_VALUE);
    }

    protected boolean checkExtraStartConditions(@Nonnull ServerLevel level, @Nonnull Scavenger owner) {
        Player player = owner.getTradingPlayer();
        return player != null && player.hasContainerOpen() && owner.distanceToSqr((Entity)player) <= 16.0 && owner.isAlive() && !owner.isAggressive() && !owner.isInWater() && !owner.hurtMarked;
    }

    protected boolean canStillUse(@Nonnull ServerLevel level, @Nonnull Scavenger entity, long gameTime) {
        return this.checkExtraStartConditions(level, entity);
    }

    protected void start(@Nonnull ServerLevel level, @Nonnull Scavenger entity, long gameTime) {
        if (entity.getTradingPlayer() != null) {
            Brain<Scavenger> brain = entity.getBrain();
            brain.setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)entity.getTradingPlayer(), false), 0.5f, 2));
            brain.setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)entity.getTradingPlayer(), true));
        }
    }

    protected void stop(@Nonnull ServerLevel level, @Nonnull Scavenger entity, long gameTime) {
        Brain<Scavenger> brain = entity.getBrain();
        brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        brain.eraseMemory(MemoryModuleType.LOOK_TARGET);
    }

    protected void tick(@Nonnull ServerLevel level, @Nonnull Scavenger owner, long gameTime) {
        if (gameTime % 5L == 0L && level.random.nextBoolean()) {
            level.broadcastEntityEvent((Entity)owner, (byte)22);
        }
    }

    protected boolean timedOut(long gameTime) {
        return false;
    }
}

