/*
 * Decompiled with CFR 0.152.
 */
package lucie.deathtaxes.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import lucie.deathtaxes.DeathTaxes;
import lucie.deathtaxes.entity.Scavenger;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;

public class ScavengerModel
extends EntityModel<Scavenger>
implements ArmedModel,
HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(DeathTaxes.withModNamespace("scavenger"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart crossedArms;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public ScavengerModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.crossedArms = root.m_171324_("crossed_arms");
        this.rightArm = root.m_171324_("right_arm");
        this.leftArm = root.m_171324_("left_arm");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftLeg = root.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171488_(-1.0f, -3.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(10.0f, -38.75f, -4.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.125f)).m_171514_(28, 53).m_171488_(9.5f, -33.75f, -4.5f, 9.0f, 2.0f, 9.0f, new CubeDeformation(0.125f)), PartPose.m_171419_((float)-14.0f, (float)24.75f, (float)0.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 36).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(28, 36).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(28, 36).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("crossed_arms", CubeListBuilder.m_171558_().m_171514_(44, 20).m_171488_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(44, 20).m_171480_().m_171488_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(40, 32).m_171488_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(@Nonnull Scavenger scavenger, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        long gameTime = scavenger.m_9236_().m_46467_();
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.rightArm.f_104204_ = 0.0f;
        this.rightArm.f_104205_ = 0.0f;
        this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.leftArm.f_104204_ = 0.0f;
        this.leftArm.f_104205_ = 0.0f;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.rightLeg.f_104204_ = 0.0f;
        this.rightLeg.f_104205_ = 0.0f;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftLeg.f_104204_ = 0.0f;
        this.leftLeg.f_104205_ = 0.0f;
        if (scavenger.unhappyCounter > gameTime) {
            this.head.f_104204_ += 0.3f * Mth.m_14031_((float)(0.45f * ageInTicks));
            this.head.f_104203_ = 0.2f;
        }
        if (scavenger.m_5912_() || scavenger.handCounter > gameTime) {
            this.leftArm.f_104207_ = true;
            this.rightArm.f_104207_ = true;
            this.crossedArms.f_104207_ = false;
            if (scavenger.m_5912_()) {
                if (scavenger.m_21205_().m_41619_()) {
                    AnimationUtils.m_102102_((ModelPart)this.leftArm, (ModelPart)this.rightArm, (boolean)true, (float)this.f_102608_, (float)ageInTicks);
                } else {
                    AnimationUtils.m_102091_((ModelPart)this.rightArm, (ModelPart)this.leftArm, (Mob)scavenger, (float)this.f_102608_, (float)ageInTicks);
                }
            } else {
                this.rightArm.f_104202_ = 0.0f;
                this.rightArm.f_104200_ = -5.0f;
                this.leftArm.f_104202_ = 0.0f;
                this.leftArm.f_104200_ = 5.0f;
                this.rightArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
                this.leftArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
                this.rightArm.f_104205_ = 2.3561945f;
                this.leftArm.f_104205_ = -2.3561945f;
                this.rightArm.f_104204_ = 0.0f;
                this.leftArm.f_104204_ = 0.0f;
            }
        } else {
            this.leftArm.f_104207_ = false;
            this.rightArm.f_104207_ = false;
            this.crossedArms.f_104207_ = true;
            this.crossedArms.f_104203_ = (float)Math.toRadians(-45.0);
        }
    }

    public void translateToArms(PoseStack poseStack) {
        this.root.m_104299_(poseStack);
        this.crossedArms.m_104299_(poseStack);
    }

    public void m_6002_(@Nonnull HumanoidArm humanoidArm, @Nonnull PoseStack poseStack) {
        this.root.m_104299_(poseStack);
        if (humanoidArm == HumanoidArm.LEFT) {
            this.leftArm.m_104299_(poseStack);
        } else {
            this.rightArm.m_104299_(poseStack);
        }
    }

    @Nonnull
    public ModelPart m_5585_() {
        return this.head;
    }

    public void m_7695_(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

