/*
 * Decompiled with CFR 0.152.
 */
package lucie.deathtaxes.entity;

import com.mojang.serialization.Dynamic;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lucie.deathtaxes.entity.ScavengerAi;
import lucie.deathtaxes.registry.ParticleTypeRegistry;
import lucie.deathtaxes.registry.SoundEventRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Scavenger
extends PathfinderMob
implements Merchant {
    @Nullable
    private Player tradingPlayer;
    @Nullable
    public MerchantOffers merchantOffers;
    public long unhappyCounter;
    public long handCounter;
    public long despawnDelay;
    public static final EntityDataAccessor<ItemStack> DATA_DISPLAY_ITEM = SynchedEntityData.m_135353_(Scavenger.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public Scavenger(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 10;
    }

    @Nonnull
    protected Brain.Provider<?> m_5490_() {
        return Brain.m_21923_(ScavengerAi.MEMORY_TYPES, ScavengerAi.SENSOR_TYPES);
    }

    @Nonnull
    protected Brain<?> m_8075_(@Nonnull Dynamic<?> dynamic) {
        return ScavengerAi.makeBrain(this, (Brain<Scavenger>)this.m_5490_().m_22073_(dynamic));
    }

    @Nonnull
    public Brain<Scavenger> m_6274_() {
        return super.m_6274_();
    }

    public static AttributeSupplier registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22281_, 0.5).m_22265_();
    }

    protected void m_8024_() {
        ProfilerFiller profilerfiller = this.m_9236_().m_46473_();
        profilerfiller.m_6180_("scavengerBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        profilerfiller.m_6182_("scavengerActivityUpdate");
        ScavengerAi.updateActivity(this);
        profilerfiller.m_7238_();
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 22) {
            double x = this.m_20185_() + this.f_19796_.m_188500_() * 5.0 - 2.5;
            double y = this.m_20186_() + this.f_19796_.m_188500_() * 2.5;
            double z = this.m_20189_() + this.f_19796_.m_188500_() * 5.0 - 2.5;
            this.m_9236_().m_7106_((ParticleOptions)((SimpleParticleType)ParticleTypeRegistry.FLY.get()), x, y, z, 0.0, 0.0, 0.0);
            if (this.f_19796_.m_188503_(8) == 0) {
                this.m_9236_().m_245747_(this.m_20183_(), (SoundEvent)SoundEventRegistry.FLIES_BUZZING.get(), SoundSource.NEUTRAL, 0.25f, 1.0f, false);
            }
        } else if (id == 23) {
            if (this.m_9236_().m_46467_() > this.unhappyCounter) {
                this.unhappyCounter = this.m_9236_().m_46467_() + 40L;
                this.f_21363_ = 0;
                this.m_9236_().m_245747_(this.m_20183_(), (SoundEvent)SoundEventRegistry.SCAVENGER_NO.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            }
        } else if (id == 24) {
            super.m_7822_((byte)60);
            this.m_9236_().m_245747_(this.m_20183_(), (SoundEvent)SoundEventRegistry.SOMETHING_TELEPORTS.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            this.m_9236_().m_245747_(this.m_20183_(), (SoundEvent)SoundEventRegistry.SCAVENGER_YES.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            this.handCounter = this.m_9236_().m_46467_() + 30L;
        }
    }

    public boolean m_7301_(@Nonnull MobEffectInstance effectInstance) {
        return !MobEffects.f_19615_.equals(effectInstance.m_19544_()) && super.m_7301_(effectInstance);
    }

    public ItemStack getDisplayItem() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_DISPLAY_ITEM);
    }

    public void setDisplayItem(ItemStack itemStack) {
        this.f_19804_.m_135381_(DATA_DISPLAY_ITEM, (Object)itemStack);
    }

    public boolean m_8023_() {
        return this.merchantOffers != null && !this.merchantOffers.isEmpty() || super.m_8023_();
    }

    public void m_6043_() {
        if (this.m_8023_()) {
            boolean shouldDespawn;
            boolean bl = shouldDespawn = this.merchantOffers != null && this.merchantOffers.stream().allMatch(MerchantOffer::m_45380_) || this.despawnDelay != 0L && this.m_9236_().m_46467_() > this.despawnDelay;
            if (shouldDespawn && this.tradingPlayer == null) {
                this.m_216990_((SoundEvent)SoundEventRegistry.SOMETHING_TELEPORTS.get());
                this.m_9236_().m_7605_((Entity)this, (byte)60);
                this.m_146870_();
                return;
            }
        }
        super.m_6043_();
    }

    public boolean m_7327_(@Nonnull Entity entity) {
        if (super.m_7327_(entity)) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                float duration = this.m_9236_().m_6436_(this.m_20183_()).m_19056_();
                livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19615_, 140 * (int)duration), (Entity)this);
            }
            return true;
        }
        return false;
    }

    public boolean m_6469_(@Nonnull DamageSource damageSource, float amount) {
        if (super.m_6469_(damageSource, amount)) {
            Entity entity = damageSource.m_7639_();
            if (entity instanceof LivingEntity) {
                Player player;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
                    return true;
                }
                this.f_20939_.m_21879_(MemoryModuleType.f_26334_, (Object)livingEntity.m_20148_());
                this.f_20939_.m_21879_(MemoryModuleType.f_26372_, (Object)livingEntity);
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        if (this.m_6084_() && !this.m_5912_() && !this.m_20145_() && this.tradingPlayer == null) {
            if (!this.m_9236_().f_46443_) {
                if (this.m_6616_().isEmpty()) {
                    this.m_9236_().m_7605_((Entity)this, (byte)23);
                } else {
                    this.m_7189_(player);
                    this.m_45301_(player, this.m_5446_(), 0);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Nullable
    protected SoundEvent m_7975_(@Nonnull DamageSource damageSource) {
        return (SoundEvent)SoundEventRegistry.SCAVENGER_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundEventRegistry.SCAVENGER_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundEventRegistry.SCAVENGER_DEATH.get();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor level, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.m_213945_(this.f_19796_, difficulty);
        this.m_213946_(this.f_19796_, difficulty);
        if (spawnType == MobSpawnType.TRIGGERED) {
            this.despawnDelay = this.m_9236_().m_46467_() + 24000L;
            this.m_6274_().m_21879_(MemoryModuleType.f_26342_, (Object)true);
        } else {
            this.m_21446_(this.m_20183_(), 16);
        }
        return super.m_6518_(level, difficulty, spawnType, spawnGroupData, compoundTag);
    }

    protected void m_213945_(@Nonnull RandomSource randomSource, @Nonnull DifficultyInstance difficultyInstance) {
        super.m_213945_(randomSource, difficultyInstance);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42384_));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_DISPLAY_ITEM, (Object)ItemStack.f_41583_);
    }

    public void m_7380_(@Nonnull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128356_("DespawnDelay", this.despawnDelay);
        compoundTag.m_128365_("MerchantOffers", (Tag)this.m_6616_().m_45388_());
    }

    public void m_7378_(@Nonnull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.merchantOffers = Optional.of(compoundTag.m_128469_("MerchantOffers")).map(MerchantOffers::new).orElse(new MerchantOffers());
        this.despawnDelay = compoundTag.m_128454_("DespawnDelay");
    }

    public void m_7189_(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    @Nullable
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    @Nonnull
    public MerchantOffers m_6616_() {
        return this.merchantOffers != null ? this.merchantOffers : new MerchantOffers();
    }

    public void m_6255_(@Nonnull MerchantOffers merchantOffers) {
        this.merchantOffers = merchantOffers;
    }

    public void m_6996_(@Nonnull MerchantOffer merchantOffer) {
        merchantOffer.m_45374_();
        if (merchantOffer.m_45383_()) {
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), merchantOffer.m_45379_()));
        }
    }

    public void m_7713_(@Nonnull ItemStack itemStack) {
        if (!this.m_9236_().f_46443_ && this.f_21363_ > -this.m_8100_() + 20) {
            this.f_21363_ = -this.m_8100_();
            this.m_216990_(itemStack.m_41619_() ? (SoundEvent)SoundEventRegistry.SCAVENGER_NO.get() : (SoundEvent)SoundEventRegistry.SCAVENGER_YES.get());
        }
    }

    @Nonnull
    public SoundEvent m_7596_() {
        return (SoundEvent)SoundEventRegistry.SCAVENGER_TRADE.get();
    }

    public boolean m_183595_() {
        return this.m_9236_().f_46443_;
    }

    public int m_7809_() {
        return 0;
    }

    public void m_6621_(int i) {
    }

    public boolean m_7826_() {
        return false;
    }

    public boolean m_6573_(@Nonnull Player player) {
        return false;
    }

    public void m_21446_(@Nonnull BlockPos blockPos, int distance) {
        super.m_21446_(blockPos, distance);
        this.f_20939_.m_21879_(MemoryModuleType.f_26359_, (Object)GlobalPos.m_122643_((ResourceKey)this.m_9236_().m_46472_(), (BlockPos)blockPos));
    }
}

