/*
 * Decompiled with CFR 0.152.
 */
package lucie.deathtaxes.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lucie.deathtaxes.entity.Scavenger;
import lucie.deathtaxes.entity.behavior.AdvertisePlayerLoot;
import lucie.deathtaxes.entity.behavior.DramaticEntrance;
import lucie.deathtaxes.entity.behavior.FollowTradingPlayer;
import lucie.deathtaxes.entity.behavior.MoveAroundPoint;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class ScavengerAi {
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26374_, (Object)MemoryModuleType.f_26359_, (Object)MemoryModuleType.f_26334_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26373_, (Object)MemoryModuleType.f_26342_);
    protected static final ImmutableList<SensorType<? extends Sensor<? super Scavenger>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26814_);

    protected static Brain<?> makeBrain(Scavenger scavenger, Brain<Scavenger> brain) {
        ScavengerAi.initCoreActivity(brain);
        ScavengerAi.initIdleActivity(brain);
        ScavengerAi.initFightActivity(brain, scavenger);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<Scavenger> brain) {
        brain.m_21900_(Activity.f_37978_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new LookAtTargetSink(45, 90)), (Object)Pair.of((Object)0, (Object)((Object)new DramaticEntrance())), (Object)Pair.of((Object)1, (Object)new MoveToTargetSink()), (Object)Pair.of((Object)4, (Object)((Object)new FollowTradingPlayer()))));
    }

    private static void initIdleActivity(Brain<Scavenger> brain) {
        brain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)2, (Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20532_, (float)8.0f)), (Object)Pair.of((Object)3, (Object)((Object)new AdvertisePlayerLoot(400, 1600))), (Object)Pair.of((Object)3, MoveAroundPoint.create((MemoryModuleType<GlobalPos>)MemoryModuleType.f_26359_, 0.75f, 16)), (Object)Pair.of((Object)3, (Object)SetLookAndInteract.m_257430_((EntityType)EntityType.f_20532_, (int)4)), (Object)Pair.of((Object)1, (Object)StartAttacking.m_257741_(Mob::m_5912_, ScavengerAi::findNearestValidAttackTarget))));
    }

    private static void initFightActivity(Brain<Scavenger> brain, Scavenger scavenger) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)MeleeAttack.m_257733_((int)20), (Object)StopAttackingIfTargetInvalid.m_257990_(livingEntity -> !ScavengerAi.isNearestValidAttackTarget(scavenger, livingEntity)), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)1.0f)), MemoryModuleType.f_26372_);
    }

    public static void updateActivity(Scavenger scavenger) {
        scavenger.m_21561_(scavenger.m_6274_().m_21874_(MemoryModuleType.f_26372_));
        scavenger.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_37988_, (Object)Activity.f_37979_));
    }

    public static Optional<? extends LivingEntity> findNearestValidAttackTarget(Scavenger scavenger) {
        Optional optionalEntity = BehaviorUtils.m_22610_((LivingEntity)scavenger, (MemoryModuleType)MemoryModuleType.f_26334_);
        if (optionalEntity.isPresent() && Sensor.m_148312_((LivingEntity)scavenger, (LivingEntity)((LivingEntity)optionalEntity.get()))) {
            return optionalEntity;
        }
        return Optional.empty();
    }

    private static boolean isNearestValidAttackTarget(Scavenger scavenger, LivingEntity target) {
        return ScavengerAi.findNearestValidAttackTarget(scavenger).filter(livingEntity -> livingEntity == target).isPresent();
    }
}

