/*
 * Decompiled with CFR 0.152.
 */
package lucie.deathtaxes.entity.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import lucie.deathtaxes.entity.Scavenger;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;

public class AdvertisePlayerLoot
extends Behavior<Scavenger> {
    private ItemStack playerItemStack;
    private final List<ItemStack> displayItems = Lists.newArrayList();
    private int lookTime;
    private int cycleCounter;
    private int displayIndex;

    public AdvertisePlayerLoot(int minDuration, int maxDuration) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26374_, (Object)MemoryStatus.VALUE_PRESENT), minDuration, maxDuration);
    }

    protected boolean checkExtraStartConditions(@Nonnull ServerLevel level, @Nonnull Scavenger owner) {
        Brain<Scavenger> brain = owner.m_6274_();
        if (brain.m_21952_(MemoryModuleType.f_26374_).isPresent()) {
            LivingEntity livingEntity = (LivingEntity)brain.m_21952_(MemoryModuleType.f_26374_).get();
            return livingEntity.m_6095_() == EntityType.f_20532_ && owner.m_6084_() && livingEntity.m_6084_() && !owner.m_5912_() && owner.m_20280_((Entity)livingEntity) <= 17.0 && owner.m_7962_() == null;
        }
        return false;
    }

    protected boolean canStillUse(@Nonnull ServerLevel level, @Nonnull Scavenger entity, long gameTime) {
        return this.checkExtraStartConditions(level, entity) && this.lookTime > 0 && entity.m_6274_().m_21952_(MemoryModuleType.f_26374_).isPresent();
    }

    protected void start(@Nonnull ServerLevel level, @Nonnull Scavenger entity, long gameTime) {
        super.m_6735_(level, (LivingEntity)entity, gameTime);
        this.lookAtTarget(entity);
        this.cycleCounter = 0;
        this.displayIndex = 0;
        this.lookTime = 40;
    }

    protected void tick(@Nonnull ServerLevel level, @Nonnull Scavenger owner, long gameTime) {
        LivingEntity livingEntity = this.lookAtTarget(owner);
        this.findItemsToDisplay(livingEntity, owner);
        if (!this.displayItems.isEmpty()) {
            this.displayCyclingItems(owner);
        } else {
            this.setDisplayItem(owner, ItemStack.f_41583_);
            this.lookTime = Math.min(this.lookTime, 40);
        }
        --this.lookTime;
    }

    protected void stop(@Nonnull ServerLevel level, @Nonnull Scavenger entity, long gameTime) {
        super.m_6732_(level, (LivingEntity)entity, gameTime);
        entity.m_6274_().m_21936_(MemoryModuleType.f_26374_);
        this.setDisplayItem(entity, ItemStack.f_41583_);
        this.playerItemStack = null;
    }

    private void findItemsToDisplay(LivingEntity entity, Scavenger scavenger) {
        boolean flag = false;
        ItemStack itemstack = entity.m_21205_();
        if (this.playerItemStack == null || !ItemStack.m_41656_((ItemStack)this.playerItemStack, (ItemStack)itemstack)) {
            this.playerItemStack = itemstack;
            flag = true;
            this.displayItems.clear();
        }
        if (flag && !this.playerItemStack.m_41619_()) {
            scavenger.m_6616_().stream().filter(merchantOffer -> !merchantOffer.m_45380_()).filter(merchantOffer -> ItemStack.m_41656_((ItemStack)merchantOffer.m_45358_(), (ItemStack)this.playerItemStack) || ItemStack.m_41656_((ItemStack)merchantOffer.m_45364_(), (ItemStack)this.playerItemStack)).forEach(merchantOffer -> this.displayItems.add(merchantOffer.m_45370_()));
            if (!this.displayItems.isEmpty()) {
                this.lookTime = 900;
                this.setDisplayItem(scavenger, this.displayItems.get(0));
            }
        }
    }

    private void setDisplayItem(Scavenger scavenger, ItemStack itemStack) {
        scavenger.setDisplayItem(itemStack);
    }

    private LivingEntity lookAtTarget(Scavenger scavenger) {
        Brain<Scavenger> brain = scavenger.m_6274_();
        LivingEntity livingentity = (LivingEntity)brain.m_21952_(MemoryModuleType.f_26374_).get();
        brain.m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)livingentity, true));
        return livingentity;
    }

    private void displayCyclingItems(Scavenger scavenger) {
        if (this.displayItems.size() >= 2 && ++this.cycleCounter >= 40) {
            ++this.displayIndex;
            this.cycleCounter = 0;
            if (this.displayIndex > this.displayItems.size() - 1) {
                this.displayIndex = 0;
            }
            this.setDisplayItem(scavenger, this.displayItems.get(this.displayIndex));
        }
    }
}

