/*
 * Decompiled with CFR 0.152.
 */
package lucie.deathtaxes.event.hooks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lucie.deathtaxes.DeathTaxes;
import lucie.deathtaxes.capability.DroppedLootCapability;
import lucie.deathtaxes.capability.DroppedLootInitializer;
import lucie.deathtaxes.entity.Scavenger;
import lucie.deathtaxes.loot.ItemEvaluation;
import lucie.deathtaxes.registry.EntityTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.Heightmap;

public class PlayerHooks {
    public static boolean collectDrops(ServerLevel level, ServerPlayer player, Collection<ItemEntity> drops) {
        if (!((GameRules.BooleanValue)level.m_7654_().m_129900_().m_46170_(GameRules.f_46133_)).m_46223_() && !drops.isEmpty()) {
            TagKey blacklist = ItemTags.create((ResourceLocation)DeathTaxes.withModNamespace("blacklisted_loot"));
            List<ItemStack> loot = drops.stream().map(ItemEntity::m_32055_).filter(itemStack -> !itemStack.m_204117_(blacklist)).toList();
            player.getCapability(DroppedLootCapability.DROPPED_LOOT_CAPABILITY).ifPresent(capability -> {
                capability.droppedLoot = loot;
            });
            return true;
        }
        return false;
    }

    public static void copyDrops(Player original, Player current, boolean isDeath) {
        if (isDeath) {
            original.reviveCaps();
            original.getCapability(DroppedLootCapability.DROPPED_LOOT_CAPABILITY).ifPresent(oldCapability -> current.getCapability(DroppedLootCapability.DROPPED_LOOT_CAPABILITY).ifPresent(newCapability -> newCapability.copyFrom((DroppedLootInitializer)oldCapability)));
            original.invalidateCaps();
        }
    }

    public static void checkDrops(ServerLevel level, ServerPlayer player) {
        player.getCapability(DroppedLootCapability.DROPPED_LOOT_CAPABILITY).filter(cap -> !cap.droppedLoot.isEmpty()).ifPresent(cap -> PlayerHooks.spawn(player, level, cap.droppedLoot));
        player.getCapability(DroppedLootCapability.DROPPED_LOOT_CAPABILITY).ifPresent(cap -> {
            cap.droppedLoot = new ArrayList<ItemStack>();
        });
    }

    private static void spawn(ServerPlayer player, ServerLevel level, List<ItemStack> contents) {
        MerchantOffers offers = ItemEvaluation.evaluateItems(player, level, contents);
        if (!offers.isEmpty()) {
            BlockPos target = player.m_20183_();
            BlockPos spawnpoint = PlayerHooks.locate((LevelReader)level, target, level.f_46441_).orElse(target);
            Optional.ofNullable((Scavenger)((EntityType)EntityTypeRegistry.SCAVENGER.get()).m_262496_(level, spawnpoint, MobSpawnType.TRIGGERED)).ifPresent(scavenger -> {
                scavenger.merchantOffers = offers;
                scavenger.m_21446_(target, 16);
            });
        }
    }

    private static Optional<BlockPos> locate(LevelReader level, BlockPos blockPos, RandomSource randomSource) {
        SpawnPlacements.Type spawnPlacementType = SpawnPlacements.m_21752_((EntityType)((EntityType)EntityTypeRegistry.SCAVENGER.get()));
        for (int i = 0; i < 16; ++i) {
            int z;
            int y;
            int x = blockPos.m_123341_() + randomSource.m_188503_(64) - 32;
            BlockPos randomPos = new BlockPos(x, y = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z = blockPos.m_123343_() + randomSource.m_188503_(64) - 32), z);
            if (!spawnPlacementType.canSpawnAt(level, randomPos, (EntityType)EntityTypeRegistry.SCAVENGER.get()) || !PlayerHooks.accessible((BlockGetter)level, randomPos)) continue;
            return Optional.of(randomPos);
        }
        return Optional.empty();
    }

    private static boolean accessible(BlockGetter level, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos, (BlockPos)pos.m_7918_(1, 2, 1))) {
            if (level.m_8055_(blockpos).m_60812_(level, blockpos).m_83281_()) continue;
            return false;
        }
        return true;
    }
}

