/*
 * Decompiled with CFR 0.152.
 */
package lucie.deathtaxes.loot.condition;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import javax.annotation.Nonnull;
import lucie.deathtaxes.registry.LootConditionRegistry;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class HasRarityCondition
implements LootItemCondition {
    final Rarity rarity;

    public HasRarityCondition(Rarity rarity) {
        this.rarity = rarity;
    }

    @Nonnull
    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)LootConditionRegistry.HAS_RARITY.get();
    }

    @Nonnull
    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81463_);
    }

    public boolean test(LootContext lootContext) {
        ItemStack itemStack = (ItemStack)lootContext.m_78953_(LootContextParams.f_81463_);
        return itemStack != null && itemStack.m_41791_() == this.rarity;
    }

    public static class Serialize
    implements Serializer<HasRarityCondition> {
        public void serialize(@Nonnull JsonObject jsonObject, @Nonnull HasRarityCondition hasRarityCondition, @Nonnull JsonSerializationContext context) {
            jsonObject.addProperty("rarity", hasRarityCondition.rarity.toString().toUpperCase());
        }

        @Nonnull
        public HasRarityCondition deserialize(@Nonnull JsonObject jsonObject, @Nonnull JsonDeserializationContext context) {
            return new HasRarityCondition(Rarity.valueOf((String)jsonObject.get("rarity").getAsString().toUpperCase()));
        }
    }
}

