/*
 * Decompiled with CFR 0.152.
 */
package net.zusz.zcoffeecraft2;

import com.mojang.logging.LogUtils;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.zusz.zcoffeecraft2.api.coffeebeantypes.DefaultCoffeeBeanTypes;
import net.zusz.zcoffeecraft2.api.coffeeingredients.DefaultCoffeeIngredients;
import net.zusz.zcoffeecraft2.api.coffeerecipes.DefaultCoffeeRecipes;
import net.zusz.zcoffeecraft2.api.groundcoffee.DefaultGroundCoffees;
import net.zusz.zcoffeecraft2.block.ModBlocks;
import net.zusz.zcoffeecraft2.block.entity.ModBlockEntities;
import net.zusz.zcoffeecraft2.block.entity.renderer.CoffeeMachineBlockEntityRenderer;
import net.zusz.zcoffeecraft2.component.ModDataComponents;
import net.zusz.zcoffeecraft2.effect.ModEffects;
import net.zusz.zcoffeecraft2.item.ModCreativeModeTabs;
import net.zusz.zcoffeecraft2.item.ModItems;
import net.zusz.zcoffeecraft2.loot.ModLootModifiers;
import net.zusz.zcoffeecraft2.screen.ModMenuTypes;
import net.zusz.zcoffeecraft2.screen.custom.CoffeeMachineScreen;
import net.zusz.zcoffeecraft2.util.ModItemProperties;
import org.slf4j.Logger;

@Mod(value="zcoffeecraft2")
public class ZCoffeeCraft2 {
    public static final String MOD_ID = "zcoffeecraft2";
    private static final Logger LOGGER = LogUtils.getLogger();

    public ZCoffeeCraft2(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        ModCreativeModeTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModDataComponents.register(modEventBus);
        ModEffects.register(modEventBus);
        ModLootModifiers.register(modEventBus);
        modEventBus.addListener(this::addCreative);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(DefaultCoffeeRecipes::registerCoffeeRecipes);
        event.enqueueWork(DefaultCoffeeIngredients::registerCoffeeIngredients);
        event.enqueueWork(DefaultGroundCoffees::registerGroundCoffees);
        event.enqueueWork(DefaultCoffeeBeanTypes::registerCoffeeBeanTypes);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            // empty if block
        }
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            // empty if block
        }
        if (event.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @EventBusSubscriber(modid="zcoffeecraft2", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ModItemProperties.addCustomItemProperties();
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)ModMenuTypes.COFFEE_MACHINE_MENU.get(), CoffeeMachineScreen::new);
        }

        @SubscribeEvent
        public static void registerBER(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(ModBlockEntities.COFFEE_MACHINE_BE.get(), CoffeeMachineBlockEntityRenderer::new);
        }
    }
}

