/*
 * Decompiled with CFR 0.152.
 */
package net.zusz.zcoffeecraft2.api.coffeeingredients;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.ItemLike;
import net.zusz.zcoffeecraft2.api.coffeeingredients.CoffeeIngredient;

public class CoffeeIngredientRegistry {
    public static final List<CoffeeIngredient> INGREDIENTS = new ArrayList<CoffeeIngredient>();

    public static void register(CoffeeIngredient ingredient) {
        INGREDIENTS.add(ingredient);
    }

    public static Optional<ItemLike> getItemFromString(String ingredient) {
        if (ingredient != null) {
            for (CoffeeIngredient coffeeIngredient : INGREDIENTS) {
                if (!ingredient.equals(coffeeIngredient.string())) continue;
                return Optional.of(coffeeIngredient.item().asItem());
            }
        }
        return Optional.empty();
    }

    public static Optional<String> getStringFromItem(ItemLike ingredient) {
        if (ingredient != null) {
            for (CoffeeIngredient coffeeIngredient : INGREDIENTS) {
                if (!ingredient.asItem().equals(coffeeIngredient.item().asItem())) continue;
                return Optional.of(coffeeIngredient.string());
            }
        }
        return Optional.empty();
    }

    public static Optional<ItemLike> getRemaining(String ingredient) {
        if (ingredient != null) {
            for (CoffeeIngredient coffeeIngredient : INGREDIENTS) {
                if (!coffeeIngredient.string().equals(ingredient)) continue;
                return Optional.of(coffeeIngredient.remaining().asItem());
            }
        }
        return Optional.empty();
    }

    public static Optional<MutableComponent> getTooltip(String ingredient) {
        if (ingredient != null) {
            for (CoffeeIngredient coffeeIngredient : INGREDIENTS) {
                if (!coffeeIngredient.string().equals(ingredient)) continue;
                return Optional.of(coffeeIngredient.toolTip());
            }
        }
        return Optional.empty();
    }
}

