/*
 * Decompiled with CFR 0.152.
 */
package net.zusz.zcoffeecraft2.api.coffeerecipes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.level.ItemLike;
import net.zusz.zcoffeecraft2.api.coffeeingredients.CoffeeIngredientRegistry;
import net.zusz.zcoffeecraft2.api.coffeerecipes.CoffeeRecipe;
import net.zusz.zcoffeecraft2.api.secondaryeffect.SecondaryEffect;

public class CoffeeRecipeRegistry {
    private static final List<CoffeeRecipe> RECIPES = new ArrayList<CoffeeRecipe>();

    public static void register(CoffeeRecipe recipe) {
        RECIPES.add(recipe);
    }

    public static Optional<CoffeeRecipe> getRecipe(List<String> ingredients) {
        if (ingredients != null) {
            for (CoffeeRecipe recipe : RECIPES) {
                if (!recipe.ingredients().equals(ingredients)) continue;
                return Optional.of(recipe);
            }
        }
        return Optional.empty();
    }

    public static List<String> getIngredients(CoffeeRecipe recipe) {
        return recipe.ingredients();
    }

    public static List<ItemLike> getIngredientsAsItems(CoffeeRecipe recipe) {
        ArrayList<ItemLike> toReturn = new ArrayList<ItemLike>(List.of());
        for (String ingredient : recipe.ingredients()) {
            ItemLike toAdd = null;
            if (!CoffeeIngredientRegistry.getItemFromString(ingredient).isPresent()) continue;
            toAdd = CoffeeIngredientRegistry.getItemFromString(ingredient).get();
            toReturn.add(toAdd);
        }
        return toReturn;
    }

    public static boolean isValid(List<String> ingredients) {
        return CoffeeRecipeRegistry.getRecipe(ingredients).isPresent();
    }

    public static String getName(List<String> ingredients) {
        if (ingredients != null) {
            for (CoffeeRecipe recipe : RECIPES) {
                if (!new HashSet<String>(recipe.ingredients()).equals(new HashSet<String>(ingredients))) continue;
                return recipe.name();
            }
        }
        return "coffeetype.zcoffeecraft2.notype";
    }

    public static SecondaryEffect getSecondaryEffect(CoffeeRecipe recipe, String bean) {
        for (SecondaryEffect secondaryEffect : recipe.secondaryEffects()) {
            if (!secondaryEffect.bean().equals(bean)) continue;
            return secondaryEffect;
        }
        return null;
    }

    public static List<CoffeeRecipe> getAll() {
        return Collections.unmodifiableList(RECIPES);
    }

    public static void clear() {
        RECIPES.clear();
    }
}

