/*
 * Decompiled with CFR 0.152.
 */
package net.zusz.zcoffeecraft2.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.zusz.zcoffeecraft2.block.custom.enums.RoastType;
import net.zusz.zcoffeecraft2.block.entity.CoffeeCupBlockEntity;
import org.jetbrains.annotations.Nullable;

public class CoffeeCupBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final MapCodec<CoffeeCupBlock> CODEC = CoffeeCupBlock.simpleCodec(CoffeeCupBlock::new);
    public static final EnumProperty<RoastType> ROAST = EnumProperty.create((String)"roast", RoastType.class);
    private static Component name = Component.literal((String)"");

    public CoffeeCupBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(ROAST, (Comparable)((Object)RoastType.LIGHT)));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ROAST});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)3.0, (double)9.5);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        BlockEntity entity;
        if (!level.isClientSide() && (entity = level.getBlockEntity(pos)) instanceof CoffeeCupBlockEntity) {
            CoffeeCupBlockEntity coffeeCupBlockEntity = (CoffeeCupBlockEntity)entity;
            ItemStack coffeeStack = coffeeCupBlockEntity.getCoffeeStack();
            name = !coffeeStack.isEmpty() ? coffeeStack.getDisplayName() : Component.translatable((String)"block.zcoffeecraft2.coffee_cup_block");
        }
        super.onBlockStateChange(level, pos, oldState, newState);
    }

    public MutableComponent getName() {
        return name.copy();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CoffeeCupBlockEntity(blockPos, blockState);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof CoffeeCupBlockEntity) {
            CoffeeCupBlockEntity coffeeCupBlockEntity = (CoffeeCupBlockEntity)blockEntity;
            coffeeCupBlockEntity.drops();
        }
        System.out.println(ROAST);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CoffeeCupBlockEntity) {
            CoffeeCupBlockEntity coffeeCupBlockEntity = (CoffeeCupBlockEntity)blockEntity;
            ItemStack coffeeStack = coffeeCupBlockEntity.getCoffeeStack();
            if (coffeeStack.isEmpty()) {
                System.out.println("COFFEESTACKISEMPTYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY");
            } else {
                return coffeeStack;
            }
        }
        return new ItemStack((ItemLike)this);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            BlockEntity entity = level.getBlockEntity(pos);
            if (entity instanceof CoffeeCupBlockEntity) {
                CoffeeCupBlockEntity coffeeCupBlockEntity = (CoffeeCupBlockEntity)entity;
                ItemStack coffeeStack = coffeeCupBlockEntity.getCoffeeStack();
                if (!coffeeStack.isEmpty()) {
                    if (!player.isCreative() && !player.addItem(coffeeStack.copy())) {
                        player.drop(coffeeStack.copy(), false);
                    }
                    coffeeCupBlockEntity.decreaseCoffeeStack(1);
                    level.removeBlock(pos, false);
                }
            } else {
                throw new IllegalStateException("Missing CoffeeCupBlockEntity!");
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
    }
}

