/*
 * Decompiled with CFR 0.152.
 */
package net.zusz.zcoffeecraft2.block.entity;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.zusz.zcoffeecraft2.api.coffeeingredients.CoffeeIngredientRegistry;
import net.zusz.zcoffeecraft2.block.custom.CoffeeMachineBlock;
import net.zusz.zcoffeecraft2.block.entity.CoffeeMachineMethods;
import net.zusz.zcoffeecraft2.block.entity.ModBlockEntities;
import net.zusz.zcoffeecraft2.component.ModDataComponents;
import net.zusz.zcoffeecraft2.screen.custom.CoffeeMachineMenu;
import org.jetbrains.annotations.Nullable;

public class CoffeeMachineBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            CoffeeMachineBlockEntity.this.setChanged();
            if (!CoffeeMachineBlockEntity.this.level.isClientSide()) {
                CoffeeMachineBlockEntity.this.level.sendBlockUpdated(CoffeeMachineBlockEntity.this.getBlockPos(), CoffeeMachineBlockEntity.this.getBlockState(), CoffeeMachineBlockEntity.this.getBlockState(), 4);
            }
        }
    };
    private static final int INPUT_SLOT = 0;
    private static final int CONTAINER_SLOT = 1;
    private static final int FLUID_INPUT_SLOT = 2;
    private static final int INGREDIENT_SLOT_1 = 3;
    private static final int INGREDIENT_SLOT_2 = 4;
    private static final int INGREDIENT_SLOT_3 = 5;
    private static final int INGREDIENT_SLOT_4 = 6;
    private static final int OUTPUT_SLOT = 7;
    private static final int FLUID_CONTAINER_OUTPUT_SLOT = 8;
    protected final ContainerData data = new ContainerData(){

        public int get(int i) {
            return switch (i) {
                case 0 -> CoffeeMachineBlockEntity.this.progress;
                case 1 -> CoffeeMachineBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int i, int value) {
            switch (i) {
                case 0: {
                    CoffeeMachineBlockEntity.this.progress = value;
                }
                case 1: {
                    CoffeeMachineBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 20;
    private float rotation;

    public CoffeeMachineBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.COFFEE_MACHINE_BE.get(), pos, blockState);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.zcoffeecraft2.coffee_machine");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new CoffeeMachineMenu(i, inventory, this, this.data);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        pTag.putInt("coffee_machine.progress", this.progress);
        pTag.putInt("coffee_machine.max_progress", this.maxProgress);
        super.saveAdditional(pTag, pRegistries);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, pTag.getCompound("inventory"));
        this.progress = pTag.getInt("coffee_machine.progress");
        this.maxProgress = pTag.getInt("coffee_machine.max_progress");
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        if (this.hasRecipe()) {
            this.increaseCraftingProgress();
            CoffeeMachineBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void craftItem() {
        ItemStack output = CoffeeMachineMethods.getOutput(this.itemHandler.getStackInSlot(0).getItem(), this.itemHandler.getStackInSlot(1).getItem(), this.itemHandler.getStackInSlot(2).getItem(), this.itemHandler.getStackInSlot(3).getItem(), this.itemHandler.getStackInSlot(4).getItem(), this.itemHandler.getStackInSlot(5).getItem(), this.itemHandler.getStackInSlot(6).getItem());
        output = output.copyWithCount(this.itemHandler.getStackInSlot(7).getCount() + 1);
        ItemStack fluidContainerOutput = this.getContainerForFluidInput(this.itemHandler.getStackInSlot(2)).copyWithCount(this.itemHandler.getStackInSlot(8).getCount() + 1);
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.extractItem(1, 1, false);
        this.itemHandler.extractItem(2, 1, false);
        this.itemHandler.setStackInSlot(7, output);
        this.itemHandler.setStackInSlot(8, fluidContainerOutput);
        this.decreaseIngredient(3);
        this.decreaseIngredient(4);
        this.decreaseIngredient(5);
        this.decreaseIngredient(6);
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 600;
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean hasRecipe() {
        ItemStack output = CoffeeMachineMethods.getOutput(this.itemHandler.getStackInSlot(0).getItem(), this.itemHandler.getStackInSlot(1).getItem(), this.itemHandler.getStackInSlot(2).getItem(), this.itemHandler.getStackInSlot(3).getItem(), this.itemHandler.getStackInSlot(4).getItem(), this.itemHandler.getStackInSlot(5).getItem(), this.itemHandler.getStackInSlot(6).getItem());
        if (output != null) {
            return this.canInsertAmountIntoSlot(output.getCount(), 7) && this.canInsertItemIntoSlot(output, 7) && this.isFluidValid() && CoffeeMachineMethods.isValidCoffeeCombination(output);
        }
        return false;
    }

    private void decreaseIngredient(int slot) {
        Item item = this.itemHandler.getStackInSlot(slot).getItem();
        ItemStack remaining = null;
        if (CoffeeIngredientRegistry.getStringFromItem((ItemLike)item).isPresent() && CoffeeIngredientRegistry.getRemaining(CoffeeIngredientRegistry.getStringFromItem((ItemLike)item).get()).isPresent() && CoffeeIngredientRegistry.getRemaining(CoffeeIngredientRegistry.getStringFromItem((ItemLike)item).get()).get() != Items.AIR) {
            remaining = new ItemStack(CoffeeIngredientRegistry.getRemaining(CoffeeIngredientRegistry.getStringFromItem((ItemLike)item).get()).get());
        }
        this.itemHandler.extractItem(slot, 1, false);
        if (remaining != null) {
            this.itemHandler.setStackInSlot(slot, remaining);
        }
    }

    private boolean isFluidValid() {
        ItemStack input = this.itemHandler.getStackInSlot(2);
        ItemStack waterBottleStack = new ItemStack((ItemLike)Items.POTION);
        waterBottleStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.WATER));
        ItemStack container = this.getContainerForFluidInput(input);
        if (container != null) {
            return this.canInsertItemIntoSlot(container, 8) && this.canInsertAmountIntoSlot(1, 8);
        }
        return false;
    }

    private ItemStack getContainerForFluidInput(ItemStack input) {
        ItemStack waterBottleStack = new ItemStack((ItemLike)Items.POTION);
        waterBottleStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.WATER));
        Object container = input.is(waterBottleStack.getItem()) ? new ItemStack((ItemLike)Items.GLASS_BOTTLE) : (input.is(Items.WATER_BUCKET) ? new ItemStack((ItemLike)Items.BUCKET) : null);
        return container;
    }

    private boolean canInsertItemIntoSlot(ItemStack output, int slotid) {
        return this.itemHandler.getStackInSlot(slotid).isEmpty() || this.itemHandler.getStackInSlot(slotid).getItem() == output.getItem() && Objects.equals(this.itemHandler.getStackInSlot(slotid).get(ModDataComponents.ROAST), output.get(ModDataComponents.ROAST)) && Objects.equals(this.itemHandler.getStackInSlot(slotid).get(ModDataComponents.BEAN), output.get(ModDataComponents.BEAN)) && Objects.equals(this.itemHandler.getStackInSlot(slotid).get(ModDataComponents.INGREDIENTS), output.get(ModDataComponents.INGREDIENTS));
    }

    private boolean canInsertAmountIntoSlot(int count, int slotid) {
        int maxCount = this.itemHandler.getStackInSlot(slotid).isEmpty() ? 64 : this.itemHandler.getStackInSlot(slotid).getMaxStackSize();
        int currentCount = this.itemHandler.getStackInSlot(slotid).getCount();
        return maxCount >= currentCount + count;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public float getRenderingRotation() {
        if (this.level == null) {
            return 0.0f;
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)CoffeeMachineBlock.FACING);
        return switch (facing) {
            case Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> -90.0f;
            default -> 0.0f;
        };
    }
}

