/*
 * Decompiled with CFR 0.152.
 */
package net.zusz.zcoffeecraft2.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.zusz.zcoffeecraft2.api.coffeeingredients.CoffeeIngredientRegistry;
import net.zusz.zcoffeecraft2.api.coffeerecipes.CoffeeRecipeRegistry;
import net.zusz.zcoffeecraft2.api.groundcoffee.GroundCoffee;
import net.zusz.zcoffeecraft2.api.groundcoffee.GroundCoffeeRegistry;
import net.zusz.zcoffeecraft2.component.ModDataComponents;
import net.zusz.zcoffeecraft2.item.ModItems;

public class CoffeeMachineMethods {
    public static List<String> addToIngredientsList(List<String> ingredients, Item item) {
        Optional<String> stringFromItem = CoffeeIngredientRegistry.getStringFromItem((ItemLike)item);
        if (stringFromItem.isPresent()) {
            ingredients.add(stringFromItem.get());
        }
        return ingredients;
    }

    public static ItemStack addBeanAndRoastToOutput(ItemStack output, Item ground) {
        String bean = null;
        String roast = null;
        Optional<GroundCoffee> optGroundCoffee = GroundCoffeeRegistry.getGroundCoffee((ItemLike)ground);
        if (optGroundCoffee.isPresent()) {
            bean = optGroundCoffee.get().bean();
            roast = optGroundCoffee.get().roast();
            output.set(ModDataComponents.BEAN, (Object)bean);
            output.set(ModDataComponents.ROAST, (Object)roast);
            return output;
        }
        output = null;
        return output;
    }

    public static ItemStack setOutputItemBasedOnContainer(Item containter) {
        ItemStack output = null;
        if (containter == ModItems.COFFEE_CUP.get()) {
            output = new ItemStack((ItemLike)ModItems.CUP_OF_COFFEE.get(), 1);
        }
        return output;
    }

    public static ItemStack getOutput(Item input, Item container, Item fluidInputItem, Item ingredient1, Item ingredient2, Item ingredient3, Item ingredient4) {
        ItemStack output = CoffeeMachineMethods.setOutputItemBasedOnContainer(container);
        if (output != null) {
            output = CoffeeMachineMethods.addBeanAndRoastToOutput(output, input);
            List<String> ingredients = new ArrayList<String>(List.of());
            ingredients = CoffeeMachineMethods.addToIngredientsList(ingredients, ingredient1);
            ingredients = CoffeeMachineMethods.addToIngredientsList(ingredients, ingredient2);
            ingredients = CoffeeMachineMethods.addToIngredientsList(ingredients, ingredient3);
            ingredients = CoffeeMachineMethods.addToIngredientsList(ingredients, ingredient4);
            if (output != null) {
                output.set(ModDataComponents.INGREDIENTS, ingredients);
            }
        }
        return output;
    }

    public static boolean isValidCoffeeCombination(ItemStack output) {
        List ingredients = (List)output.get(ModDataComponents.INGREDIENTS);
        return CoffeeRecipeRegistry.isValid(ingredients);
    }
}

