/*
 * Decompiled with CFR 0.152.
 */
package net.zusz.zcoffeecraft2.compat;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;
import net.zusz.zcoffeecraft2.api.coffeeingredients.CoffeeIngredientRegistry;
import net.zusz.zcoffeecraft2.api.coffeerecipes.CoffeeRecipe;
import net.zusz.zcoffeecraft2.api.coffeerecipes.CoffeeRecipeRegistry;
import net.zusz.zcoffeecraft2.block.entity.CoffeeMachineMethods;
import net.zusz.zcoffeecraft2.compat.CoffeeMachineRecipe;
import net.zusz.zcoffeecraft2.component.ModDataComponents;
import net.zusz.zcoffeecraft2.item.ModItems;

public class CoffeeMachineRecipeManager {
    public static List<CoffeeMachineRecipe> getAllRecipes() {
        ItemStack waterBottleStack = new ItemStack((ItemLike)Items.POTION);
        waterBottleStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.WATER));
        Ingredient water = Ingredient.of((ItemStack[])new ItemStack[]{waterBottleStack, new ItemStack((ItemLike)Items.WATER_BUCKET)});
        Ingredient water_output = Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS_BOTTLE, Items.BUCKET});
        ArrayList<CoffeeMachineRecipe> CoffeeMachineRecipes = new ArrayList<CoffeeMachineRecipe>();
        ArrayList<DeferredItem<Item>> groundCoffees = new ArrayList<DeferredItem<Item>>(List.of(ModItems.LIGHT_ARABICA_GROUND_COFFEE, ModItems.MEDIUM_ARABICA_GROUND_COFFEE, ModItems.DARK_ARABICA_GROUND_COFFEE, ModItems.LIGHT_ROBUSTA_GROUND_COFFEE, ModItems.MEDIUM_ROBUSTA_GROUND_COFFEE, ModItems.DARK_ROBUSTA_GROUND_COFFEE, ModItems.LIGHT_LIBERICA_GROUND_COFFEE, ModItems.MEDIUM_LIBERICA_GROUND_COFFEE, ModItems.DARK_LIBERICA_GROUND_COFFEE));
        ArrayList<DeferredItem<Item>> containers = new ArrayList<DeferredItem<Item>>(List.of(ModItems.COFFEE_CUP));
        ArrayList<Ingredient> fluidItems = new ArrayList<Ingredient>(List.of(water));
        ArrayList ingredientSets = new ArrayList(List.of());
        for (CoffeeRecipe coffeeRecipe : CoffeeRecipeRegistry.getAll()) {
            ArrayList<ItemLike> itemIngredients = new ArrayList<ItemLike>(List.of());
            for (String ingredient : CoffeeRecipeRegistry.getIngredients(coffeeRecipe)) {
                if (!CoffeeIngredientRegistry.getItemFromString(ingredient).isPresent()) continue;
                itemIngredients.add(CoffeeIngredientRegistry.getItemFromString(ingredient).get());
            }
            ingredientSets.add(itemIngredients);
        }
        for (ItemLike itemLike : groundCoffees) {
            for (ItemLike itemLike2 : containers) {
                for (Ingredient fluidItem : fluidItems) {
                    for (List list : ingredientSets) {
                        Ingredient ingredient1 = list.size() > 0 ? Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)list.get(0)}) : Ingredient.EMPTY;
                        Ingredient ingredient2 = list.size() > 1 ? Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)list.get(1)}) : Ingredient.EMPTY;
                        Ingredient ingredient3 = list.size() > 2 ? Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)list.get(2)}) : Ingredient.EMPTY;
                        Ingredient ingredient4 = list.size() > 3 ? Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)list.get(3)}) : Ingredient.EMPTY;
                        Item ing1 = list.size() > 0 ? ((ItemLike)list.get(0)).asItem() : null;
                        Item ing2 = list.size() > 1 ? ((ItemLike)list.get(1)).asItem() : null;
                        Item ing3 = list.size() > 2 ? ((ItemLike)list.get(2)).asItem() : null;
                        Item ing4 = list.size() > 3 ? ((ItemLike)list.get(3)).asItem() : null;
                        Ingredient fluidOutput = Ingredient.EMPTY;
                        if (fluidItem == water) {
                            fluidOutput = water_output;
                        }
                        CoffeeMachineRecipes.add(new CoffeeMachineRecipe(Ingredient.of((ItemLike[])new ItemLike[]{itemLike}), Ingredient.of((ItemLike[])new ItemLike[]{itemLike2}), fluidItem, ingredient1, ingredient2, ingredient3, ingredient4, CoffeeMachineRecipeManager.getResult(itemLike.asItem(), itemLike2.asItem(), null, ing1, ing2, ing3, ing4), fluidOutput));
                    }
                }
            }
        }
        return CoffeeMachineRecipes;
    }

    public static ItemStack getResult(Item input, Item container, Item fluidInputItem, Item ingredient1, Item ingredient2, Item ingredient3, Item ingredient4) {
        ItemStack output = CoffeeMachineRecipeManager.setOutputItemBasedOnContainer(container);
        output = CoffeeMachineRecipeManager.addBeanAndRoastToOutput(output, input);
        List<String> ingredients = new ArrayList<String>(List.of());
        ingredients = CoffeeMachineRecipeManager.addToIngredientsList(ingredients, ingredient1);
        ingredients = CoffeeMachineRecipeManager.addToIngredientsList(ingredients, ingredient2);
        ingredients = CoffeeMachineRecipeManager.addToIngredientsList(ingredients, ingredient3);
        ingredients = CoffeeMachineRecipeManager.addToIngredientsList(ingredients, ingredient4);
        output.set(ModDataComponents.INGREDIENTS, ingredients);
        return output;
    }

    public static List<String> addToIngredientsList(List<String> ingredients, Item item) {
        CoffeeMachineMethods.addToIngredientsList(ingredients, item);
        return ingredients;
    }

    public static ItemStack addBeanAndRoastToOutput(ItemStack output, Item bean) {
        if (CoffeeMachineMethods.addBeanAndRoastToOutput(output, bean) != null) {
            output = CoffeeMachineMethods.addBeanAndRoastToOutput(output, bean);
        }
        return output;
    }

    public static ItemStack setOutputItemBasedOnContainer(Item containter) {
        ItemStack output = null;
        if (containter == ModItems.COFFEE_CUP.get()) {
            output = new ItemStack((ItemLike)ModItems.CUP_OF_COFFEE.get(), 1);
        }
        return output;
    }
}

