/*
 * Decompiled with CFR 0.152.
 */
package net.zusz.zcoffeecraft2.item.custom.coffeeitem;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.zusz.zcoffeecraft2.api.coffeebeantypes.CoffeeBeanTypeRegistry;
import net.zusz.zcoffeecraft2.api.coffeeingredients.CoffeeIngredientRegistry;
import net.zusz.zcoffeecraft2.api.coffeerecipes.CoffeeRecipe;
import net.zusz.zcoffeecraft2.api.coffeerecipes.CoffeeRecipeRegistry;
import net.zusz.zcoffeecraft2.block.ModBlocks;
import net.zusz.zcoffeecraft2.block.custom.CoffeeCupBlock;
import net.zusz.zcoffeecraft2.block.custom.enums.RoastType;
import net.zusz.zcoffeecraft2.block.entity.CoffeeCupBlockEntity;
import net.zusz.zcoffeecraft2.component.ModDataComponents;
import net.zusz.zcoffeecraft2.effect.CoffeeEffectData;
import net.zusz.zcoffeecraft2.effect.CoffeeEffectInstance;
import net.zusz.zcoffeecraft2.effect.ModEffects;
import net.zusz.zcoffeecraft2.screen.custom.CoffeeMachineScreen;
import org.jetbrains.annotations.NotNull;

public class CoffeeItem
extends Item {
    public CoffeeItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level level, @NotNull LivingEntity entity) {
        ServerPlayer player;
        block10: {
            block9: {
                if (!(entity instanceof ServerPlayer)) break block9;
                player = (ServerPlayer)entity;
                if (!level.isClientSide) break block10;
            }
            return stack;
        }
        Optional<CoffeeRecipe> recipeOpt = CoffeeRecipeRegistry.getRecipe((List)stack.get(ModDataComponents.INGREDIENTS));
        if (recipeOpt.isEmpty()) {
            return stack;
        }
        CoffeeRecipe recipe = recipeOpt.get();
        String bean = (String)stack.get(ModDataComponents.BEAN);
        String roast = (String)stack.get(ModDataComponents.ROAST);
        int duration = this.adjustDuration(recipe.baseDuration(), bean, roast);
        int amplifier = recipe.baseAmplifier() + this.getBeanAmplifier(bean);
        int delay = recipe.baseDelay() + this.getRoastDelay(roast);
        Holder<MobEffect> secondaryEffect = null;
        int secondaryDuration = 0;
        int secondaryAmplifier = 0;
        if (CoffeeBeanTypeRegistry.getBeanTypeFromString(bean).isPresent() && CoffeeBeanTypeRegistry.getBeanTypeFromString(bean).get().hasSecondaryEffect().booleanValue() && CoffeeRecipeRegistry.getSecondaryEffect(recipe, bean) != null) {
            if (CoffeeRecipeRegistry.getSecondaryEffect(recipe, bean).secondaryEffect().isPresent()) {
                secondaryEffect = CoffeeRecipeRegistry.getSecondaryEffect(recipe, bean).secondaryEffect().get();
            }
            if (CoffeeRecipeRegistry.getSecondaryEffect(recipe, bean).secondaryDuration().isPresent()) {
                secondaryDuration = CoffeeRecipeRegistry.getSecondaryEffect(recipe, bean).secondaryDuration().get();
            }
            if (CoffeeRecipeRegistry.getSecondaryEffect(recipe, bean).secondaryAmplifier().isPresent()) {
                secondaryAmplifier = CoffeeRecipeRegistry.getSecondaryEffect(recipe, bean).secondaryAmplifier().get();
            }
        }
        CoffeeEffectInstance ceffect = new CoffeeEffectInstance((MobEffect)recipe.effect().value(), duration, amplifier, delay, secondaryEffect, secondaryDuration, secondaryAmplifier);
        CoffeeEffectData.addEffect(player, ceffect);
        if (delay > 0) {
            player.addEffect(new MobEffectInstance(ModEffects.CAFFEINATED_EFFECT, delay, 0));
        }
        return super.finishUsingItem(stack, level, entity);
    }

    private int adjustDuration(int base, String bean, String roast) {
        int duration = base;
        if (CoffeeBeanTypeRegistry.getBeanTypeFromString(bean).isPresent()) {
            duration += CoffeeBeanTypeRegistry.getBeanTypeFromString(bean).get().coffeeDurationModifier().intValue();
        }
        if ("dark".equals(roast)) {
            duration += 2400;
        }
        if ("medium".equals(roast)) {
            duration += 1200;
        }
        return duration;
    }

    private int getBeanAmplifier(@Nullable String bean) {
        if (CoffeeBeanTypeRegistry.getBeanTypeFromString(bean).isPresent()) {
            return CoffeeBeanTypeRegistry.getBeanTypeFromString(bean).get().coffeeAmplifierModifier();
        }
        return 0;
    }

    private int getRoastDelay(@Nullable String roast) {
        if (roast == null) {
            return 0;
        }
        return switch (roast) {
            case "light" -> 0;
            case "medium" -> 200;
            case "dark" -> 500;
            default -> 0;
        };
    }

    @NotNull
    public Component getName(ItemStack stack) {
        List ingredients = (List)stack.get(ModDataComponents.INGREDIENTS);
        String roast = (String)stack.get(ModDataComponents.ROAST);
        MutableComponent coffeeComponent = Component.translatable((String)CoffeeRecipeRegistry.getName(ingredients));
        MutableComponent roastComponent = Component.translatable((String)"coffeeroast.zcoffeecraft2.noroast");
        if (roast != null) {
            if (Objects.equals(roast, "light")) {
                roastComponent = Component.translatable((String)"coffeeroast.zcoffeecraft2.light");
            } else if (Objects.equals(roast, "medium")) {
                roastComponent = Component.translatable((String)"coffeeroast.zcoffeecraft2.medium");
            } else if (Objects.equals(roast, "dark")) {
                roastComponent = Component.translatable((String)"coffeeroast.zcoffeecraft2.dark");
            }
        }
        return Component.translatable((String)"coffeetype.zcoffeecraft2.base", (Object[])new Object[]{roastComponent, coffeeComponent});
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    private boolean isInJEIContext() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(element -> element.getClassName().contains("mezz.jei"));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        List<String> ingredients;
        Optional<CoffeeRecipe> recipeOpt;
        boolean showDetails;
        boolean inJEI = this.isInJEIContext();
        boolean inCoffeeMachine = Minecraft.getInstance().screen instanceof CoffeeMachineScreen;
        boolean bl = showDetails = Screen.hasShiftDown() && inCoffeeMachine || inJEI;
        if (showDetails) {
            tooltipComponents.add((Component)Component.translatable((String)"coffeedescription.zcoffeecraft2.beans").withStyle(ChatFormatting.BLUE));
            String bean = (String)stack.get(ModDataComponents.BEAN);
            if (CoffeeBeanTypeRegistry.getBeanTypeFromString(bean).isPresent()) {
                tooltipComponents.add((Component)CoffeeBeanTypeRegistry.getBeanTypeFromString(bean).get().toolTip().withStyle(ChatFormatting.GRAY));
            }
            tooltipComponents.add((Component)Component.translatable((String)"coffeedescription.zcoffeecraft2.roast").withStyle(ChatFormatting.BLUE));
            String roast = (String)stack.get(ModDataComponents.ROAST);
            if (roast == null) {
                tooltipComponents.add((Component)Component.literal((String)"   -Depends on Bean roast").withStyle(ChatFormatting.GRAY));
            } else {
                switch (roast) {
                    case "light": {
                        tooltipComponents.add((Component)Component.translatable((String)"coffeedescription.zcoffeecraft2.light").withStyle(ChatFormatting.GRAY));
                        break;
                    }
                    case "medium": {
                        tooltipComponents.add((Component)Component.translatable((String)"coffeedescription.zcoffeecraft2.medium").withStyle(ChatFormatting.GRAY));
                        break;
                    }
                    case "dark": {
                        tooltipComponents.add((Component)Component.translatable((String)"coffeedescription.zcoffeecraft2.dark").withStyle(ChatFormatting.GRAY));
                        break;
                    }
                    default: {
                        tooltipComponents.add((Component)Component.literal((String)"   -Unknown Roast").withStyle(ChatFormatting.GRAY));
                    }
                }
            }
            List ingredients2 = (List)stack.get(ModDataComponents.INGREDIENTS);
            if (ingredients2 != null && !ingredients2.isEmpty()) {
                tooltipComponents.add((Component)Component.translatable((String)"coffeedescription.zcoffeecraft2.ingredients").withStyle(ChatFormatting.BLUE));
                for (String item : ingredients2) {
                    if (!CoffeeIngredientRegistry.getTooltip(item).isPresent()) continue;
                    tooltipComponents.add((Component)CoffeeIngredientRegistry.getTooltip(item).get().withStyle(ChatFormatting.GRAY));
                }
            }
        } else if (inCoffeeMachine) {
            tooltipComponents.add((Component)Component.translatable((String)"coffeedescription.zcoffeecraft2.shifttoseemoreinfo"));
        }
        if ((recipeOpt = CoffeeRecipeRegistry.getRecipe((ingredients = (List<String>)stack.get(ModDataComponents.INGREDIENTS)) != null ? ingredients : List.of())).isEmpty()) {
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
            return;
        }
        CoffeeRecipe recipe = recipeOpt.get();
        String bean = (String)stack.get(ModDataComponents.BEAN);
        String roast = (String)stack.get(ModDataComponents.ROAST);
        int duration = this.adjustDuration(recipe.baseDuration(), bean, roast);
        int amplifier = recipe.baseAmplifier() + this.getBeanAmplifier(bean);
        int delay = recipe.baseDelay() + this.getRoastDelay(roast);
        Holder<MobEffect> effect = recipe.effect();
        Component effectName = this.getEffectNameComponent(effect);
        MutableComponent potency = amplifier != 0 ? Component.translatable((String)("potion.potency." + amplifier)) : (effect != null ? Component.literal((String)"I") : Component.literal((String)""));
        MutableComponent durationComponent = !this.getFormattedDuration(duration).isEmpty() ? Component.literal((String)(" (" + this.getFormattedDuration(duration) + ")")) : Component.literal((String)"");
        MutableComponent delayComponent = !this.getFormattedDuration(delay).isEmpty() ? Component.literal((String)(" [" + this.getFormattedDuration(delay) + "]")) : Component.literal((String)"");
        tooltipComponents.add((Component)Component.literal((String)"").append((Component)effectName.copy().withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)" ").withStyle(ChatFormatting.BLUE)).append((Component)potency.copy().withStyle(ChatFormatting.BLUE)).append((Component)durationComponent.copy().withStyle(ChatFormatting.BLUE)).append((Component)delayComponent.copy().withStyle(ChatFormatting.GOLD)));
        Holder<MobEffect> sEffect = null;
        int secondaryDuration = 0;
        if (CoffeeRecipeRegistry.getSecondaryEffect(recipe, bean) != null) {
            if (CoffeeRecipeRegistry.getSecondaryEffect(recipe, bean).secondaryEffect().isPresent()) {
                sEffect = CoffeeRecipeRegistry.getSecondaryEffect(recipe, bean).secondaryEffect().get();
            }
            if (CoffeeRecipeRegistry.getSecondaryEffect(recipe, bean).secondaryDuration().isPresent()) {
                secondaryDuration = CoffeeRecipeRegistry.getSecondaryEffect(recipe, bean).secondaryDuration().get();
            }
        }
        if (sEffect != null) {
            String sFormattedDuration = this.getFormattedDuration(secondaryDuration);
            MutableComponent sDurationComponent = !sFormattedDuration.isEmpty() ? Component.literal((String)(" (" + sFormattedDuration + ")")) : Component.literal((String)"");
            MutableComponent sPotency = Component.literal((String)"I");
            Component sEffectName = this.getEffectNameComponent(sEffect);
            tooltipComponents.add((Component)Component.literal((String)"").append((Component)sEffectName.copy().withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)" ").withStyle(ChatFormatting.BLUE)).append((Component)sPotency.copy().withStyle(ChatFormatting.BLUE)).append((Component)sDurationComponent.copy().withStyle(ChatFormatting.BLUE)).append((Component)delayComponent.copy().withStyle(ChatFormatting.GOLD)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    private Component getEffectNameComponent(Holder<MobEffect> effect) {
        if (effect == null) {
            return Component.literal((String)"");
        }
        if (effect == MobEffects.MOVEMENT_SPEED) {
            return Component.translatable((String)"effect.minecraft.speed");
        }
        if (effect == MobEffects.JUMP) {
            return Component.translatable((String)"effect.minecraft.jump_boost");
        }
        if (effect == MobEffects.ABSORPTION) {
            return Component.translatable((String)"effect.minecraft.absorption");
        }
        if (effect == MobEffects.DAMAGE_RESISTANCE) {
            return Component.translatable((String)"effect.minecraft.resistance");
        }
        if (effect == MobEffects.REGENERATION) {
            return Component.translatable((String)"effect.minecraft.regeneration");
        }
        if (effect == MobEffects.HEALTH_BOOST) {
            return Component.translatable((String)"effect.minecraft.health_boost");
        }
        if (effect == MobEffects.DAMAGE_BOOST) {
            return Component.translatable((String)"effect.minecraft.strength");
        }
        if (effect == MobEffects.NIGHT_VISION) {
            return Component.translatable((String)"effect.minecraft.night_vision");
        }
        return Component.literal((String)"");
    }

    private String getFormattedDuration(int duration) {
        if (duration >= 1) {
            int durationSeconds = duration / 20;
            int minutes = durationSeconds / 60;
            int seconds = durationSeconds % 60;
            String formattedDuration = String.format("%d:%02d", minutes, seconds);
            return formattedDuration;
        }
        return "";
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity;
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        InteractionHand hand = context.getHand();
        ItemStack stack = context.getItemInHand();
        if (player == null || !player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        BlockPos placePos = clickedPos.relative(context.getClickedFace());
        BlockState existingState = level.getBlockState(placePos);
        if (!existingState.canBeReplaced()) {
            return InteractionResult.FAIL;
        }
        BlockState state = (BlockState)((Block)ModBlocks.COFFEE_CUP_BLOCK.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)player.getDirection().getOpposite());
        String roast = (String)stack.get(ModDataComponents.ROAST);
        if (roast != null) {
            switch (roast) {
                case "medium": {
                    state = (BlockState)state.setValue(CoffeeCupBlock.ROAST, (Comparable)((Object)RoastType.MEDIUM));
                    break;
                }
                case "dark": {
                    state = (BlockState)state.setValue(CoffeeCupBlock.ROAST, (Comparable)((Object)RoastType.DARK));
                    break;
                }
                default: {
                    state = (BlockState)state.setValue(CoffeeCupBlock.ROAST, (Comparable)((Object)RoastType.LIGHT));
                }
            }
        }
        if (!level.isClientSide) {
            level.setBlock(placePos, state, 11);
        }
        if ((blockEntity = level.getBlockEntity(placePos)) instanceof CoffeeCupBlockEntity) {
            CoffeeCupBlockEntity cupEntity = (CoffeeCupBlockEntity)blockEntity;
            ItemStack toSet = new ItemStack((ItemLike)stack.getItem());
            toSet.set(ModDataComponents.ROAST, (Object)((String)stack.get(ModDataComponents.ROAST)));
            toSet.set(ModDataComponents.BEAN, (Object)((String)stack.get(ModDataComponents.BEAN)));
            toSet.set(ModDataComponents.INGREDIENTS, (Object)((List)stack.get(ModDataComponents.INGREDIENTS)));
            cupEntity.setCoffeeStack(toSet);
        }
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

