/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.stirdrem.overgeared.config.ServerConfig;

public class ClientAnvilMinigameData {
    public static UUID ownerUUID = null;
    private static boolean isVisible = false;
    public static boolean minigameStarted = false;
    public static ItemStack resultItem = null;
    public static int hitsRemaining = 0;
    public static float arrowPosition = 0.0f;
    public static float arrowSpeed = ((Double)ServerConfig.POOR_ARROW_SPEED.get()).floatValue();
    public static final float maxArrowSpeed = ((Double)ServerConfig.POOR_MAX_ARROW_SPEED.get()).floatValue();
    public static float speedIncreasePerHit = ((Double)ServerConfig.POOR_ARROW_SPEED_INCREASE.get()).floatValue();
    public static boolean movingRight = true;
    public static int perfectHits = 0;
    public static int goodHits = 0;
    public static int missedHits = 0;
    public static int perfectZoneStart = (100 - (Integer)ServerConfig.POOR_ZONE_STARTING_SIZE.get()) / 2;
    public static int perfectZoneEnd = (100 + (Integer)ServerConfig.POOR_ZONE_STARTING_SIZE.get()) / 2;
    public static int goodZoneStart = perfectZoneStart - 10;
    public static int goodZoneEnd = perfectZoneEnd + 10;
    public static float zoneShrinkFactor = 0.8f;
    public static float zoneShiftAmount = 15.0f;
    public static Map<BlockPos, UUID> occupiedAnvils = Collections.synchronizedMap(new HashMap());
    public static int skillLevel = 0;
    private static BlockPos pendingMinigamePos = null;

    public static void setIsVisible(boolean visible) {
        isVisible = visible;
    }

    public static boolean getIsVisible() {
        return isVisible;
    }

    public static void setResultItem(ItemStack item) {
        resultItem = item;
    }

    public static ItemStack getResultItem() {
        return resultItem;
    }

    public static void setHitsRemaining(int hits) {
        hitsRemaining = hits;
    }

    public static int getHitsRemaining() {
        return hitsRemaining;
    }

    public static void setArrowPosition(float position) {
        arrowPosition = position;
    }

    public static float getArrowPosition() {
        return arrowPosition;
    }

    public static void setArrowSpeed(float speed) {
        arrowSpeed = speed;
    }

    public static float getArrowSpeed() {
        return arrowSpeed;
    }

    public static float getMaxArrowSpeed() {
        return maxArrowSpeed;
    }

    public static void setSpeedIncreasePerHit(float increase) {
        speedIncreasePerHit = increase;
    }

    public static float getSpeedIncreasePerHit() {
        return speedIncreasePerHit;
    }

    public static void setMovingRight(boolean right) {
        movingRight = right;
    }

    public static boolean isMovingRight() {
        return movingRight;
    }

    public static void setPerfectHits(int hits) {
        perfectHits = hits;
    }

    public static int getPerfectHits() {
        return perfectHits;
    }

    public static void setGoodHits(int hits) {
        goodHits = hits;
    }

    public static int getGoodHits() {
        return goodHits;
    }

    public static void setMissedHits(int hits) {
        missedHits = hits;
    }

    public static int getMissedHits() {
        return missedHits;
    }

    public static void setPerfectZoneStart(int start) {
        perfectZoneStart = start;
    }

    public static int getPerfectZoneStart() {
        return perfectZoneStart;
    }

    public static void setPerfectZoneEnd(int end) {
        perfectZoneEnd = end;
    }

    public static int getPerfectZoneEnd() {
        return perfectZoneEnd;
    }

    public static void setGoodZoneStart(int start) {
        goodZoneStart = start;
    }

    public static int getGoodZoneStart() {
        return goodZoneStart;
    }

    public static void setGoodZoneEnd(int end) {
        goodZoneEnd = end;
    }

    public static int getGoodZoneEnd() {
        return goodZoneEnd;
    }

    public static void setZoneShrinkFactor(float factor) {
        zoneShrinkFactor = factor;
    }

    public static float getZoneShrinkFactor() {
        return zoneShrinkFactor;
    }

    public static void setZoneShiftAmount(float amount) {
        zoneShiftAmount = amount;
    }

    public static float getZoneShiftAmount() {
        return zoneShiftAmount;
    }

    public static void loadFromNBT(CompoundTag nbt) {
        isVisible = nbt.m_128441_("isVisible") && nbt.m_128471_("isVisible");
        ownerUUID = nbt.m_128403_("ownerUUID") ? nbt.m_128342_("ownerUUID") : null;
        minigameStarted = nbt.m_128441_("minigameStarted") && nbt.m_128471_("minigameStarted");
        resultItem = nbt.m_128441_("resultItem") ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_("resultItem")) : ItemStack.f_41583_;
        hitsRemaining = nbt.m_128441_("hitsRemaining") ? nbt.m_128451_("hitsRemaining") : 0;
        perfectHits = nbt.m_128441_("perfectHits") ? nbt.m_128451_("perfectHits") : 0;
        goodHits = nbt.m_128441_("goodHits") ? nbt.m_128451_("goodHits") : 0;
        missedHits = nbt.m_128441_("missedHits") ? nbt.m_128451_("missedHits") : 0;
        arrowPosition = nbt.m_128441_("arrowPosition") ? nbt.m_128457_("arrowPosition") : 0.0f;
        arrowSpeed = nbt.m_128441_("arrowSpeed") ? nbt.m_128457_("arrowSpeed") : ((Double)ServerConfig.POOR_ARROW_SPEED.get()).floatValue();
        speedIncreasePerHit = nbt.m_128441_("speedIncreasePerHit") ? nbt.m_128457_("speedIncreasePerHit") : ((Double)ServerConfig.POOR_ARROW_SPEED_INCREASE.get()).floatValue();
        movingRight = !nbt.m_128441_("movingRight") || nbt.m_128471_("movingRight");
        perfectZoneStart = nbt.m_128441_("perfectZoneStart") ? nbt.m_128451_("perfectZoneStart") : (100 - (Integer)ServerConfig.POOR_ZONE_STARTING_SIZE.get()) / 2;
        perfectZoneEnd = nbt.m_128441_("perfectZoneEnd") ? nbt.m_128451_("perfectZoneEnd") : (100 + (Integer)ServerConfig.POOR_ZONE_STARTING_SIZE.get()) / 2;
        goodZoneStart = nbt.m_128441_("goodZoneStart") ? nbt.m_128451_("goodZoneStart") : Mth.m_14045_((int)(perfectZoneStart - 20), (int)0, (int)100);
        int n = goodZoneEnd = nbt.m_128441_("goodZoneEnd") ? nbt.m_128451_("goodZoneEnd") : Mth.m_14045_((int)(perfectZoneEnd + 20), (int)goodZoneStart, (int)100);
        if (nbt.m_128441_("zoneShrinkFactor")) {
            zoneShrinkFactor = nbt.m_128457_("zoneShrinkFactor");
        }
        if (nbt.m_128441_("zoneShiftAmount")) {
            zoneShiftAmount = nbt.m_128457_("zoneShiftAmount");
        }
        arrowSpeed = Math.min(arrowSpeed, maxArrowSpeed);
        arrowPosition = Mth.m_14036_((float)arrowPosition, (float)0.0f, (float)100.0f);
        perfectZoneStart = Mth.m_14045_((int)perfectZoneStart, (int)0, (int)100);
        perfectZoneEnd = Mth.m_14045_((int)perfectZoneEnd, (int)perfectZoneStart, (int)100);
        goodZoneStart = Mth.m_14045_((int)goodZoneStart, (int)0, (int)100);
        goodZoneEnd = Mth.m_14045_((int)goodZoneEnd, (int)goodZoneStart, (int)100);
    }

    public static UUID getOccupiedAnvil(BlockPos pos) {
        return occupiedAnvils.get(pos);
    }

    public static void putOccupiedAnvil(BlockPos pos, UUID me) {
        occupiedAnvils.put(pos, me);
    }

    public static void setPendingMinigame(BlockPos pos) {
        pendingMinigamePos = pos;
    }

    public static BlockPos getPendingMinigamePos() {
        return pendingMinigamePos;
    }

    public static void clearPendingMinigame() {
        pendingMinigamePos = null;
    }

    public static int getSkillLevel() {
        return skillLevel;
    }
}

