/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.compat;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.recipe.ItemToToolTypeRecipe;
import net.stirdrem.overgeared.recipe.ModRecipeTypes;
import net.stirdrem.overgeared.util.CastingConfigHelper;

public final class ClayToolCastRecipeMaker {
    private ClayToolCastRecipeMaker() {
    }

    public static List<CraftingRecipe> createRecipes(RecipeManager recipeManager) {
        List itemToToolTypeRecipes = recipeManager.m_44013_((RecipeType)ModRecipeTypes.ITEM_TO_TOOLTYPE.get());
        Map<String, List<ItemToToolTypeRecipe>> grouped = itemToToolTypeRecipes.stream().collect(Collectors.groupingBy(ItemToToolTypeRecipe::getToolType));
        return grouped.entrySet().stream().map(entry -> {
            String toolType = (String)entry.getKey();
            List<Item> toolHeads = ((List)entry.getValue()).stream().flatMap(r -> r.getItems().stream()).map(ItemStack::m_41720_).filter(item -> item != Items.f_41852_).distinct().toList();
            if (toolHeads.isEmpty()) {
                return null;
            }
            return ClayToolCastRecipeMaker.createRecipe(toolHeads, toolType);
        }).filter(Objects::nonNull).toList();
    }

    private static CraftingRecipe createRecipe(List<Item> toolHeads, String toolType) {
        Ingredient headIngredient = Ingredient.m_43921_(toolHeads.stream().map(ItemStack::new));
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.f_43901_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42461_}), Ingredient.f_43901_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42461_}), headIngredient, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42461_}), Ingredient.f_43901_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42461_}), Ingredient.f_43901_});
        ItemStack output = ClayToolCastRecipeMaker.createOutput(toolType);
        ResourceLocation id = ResourceLocation.m_214293_((String)"overgeared", (String)("jei.clay_cast." + toolType));
        return new ShapedRecipe(id, "jei.clay_cast", CraftingBookCategory.MISC, 3, 3, inputs, output);
    }

    private static ItemStack createOutput(String toolType) {
        ItemStack result = new ItemStack((ItemLike)ModItems.UNFIRED_TOOL_CAST.get());
        CompoundTag tag = result.m_41784_();
        tag.m_128359_("ToolType", toolType);
        tag.m_128405_("Amount", 0);
        tag.m_128405_("MaxAmount", CastingConfigHelper.getMaxMaterialAmount(toolType));
        return result;
    }
}

