/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.entity.custom;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.stirdrem.overgeared.OvergearedMod;
import net.stirdrem.overgeared.entity.ArrowTier;
import net.stirdrem.overgeared.entity.ModEntities;
import net.stirdrem.overgeared.item.ModItems;

public class UpgradeArrowEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> DATA_TIER = SynchedEntityData.m_135353_(UpgradeArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> DATA_POTION_COLOR = SynchedEntityData.m_135353_(UpgradeArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ItemStack referenceStack;
    private final Set<MobEffectInstance> effects = Sets.newHashSet();
    private Potion potion = Potions.f_43598_;

    public UpgradeArrowEntity(ArrowTier tier, Level level, LivingEntity shooter, ItemStack stack) {
        super((EntityType)ModEntities.UPGRADE_ARROW.get(), shooter, level);
        this.referenceStack = stack;
        this.f_19804_.m_135381_(DATA_TIER, (Object)((byte)tier.ordinal()));
        CompoundTag tag = stack.m_41783_();
        int color = -1;
        if (tag != null && (tag.m_128441_("Potion") || tag.m_128441_("CustomPotionEffects") || tag.m_128441_("LingeringPotion"))) {
            color = OvergearedMod.ClientModEvents.getColor(stack);
        }
        this.f_19804_.m_135381_(DATA_POTION_COLOR, (Object)color);
        this.potion = UpgradeArrowEntity.getPotion(tag);
    }

    public UpgradeArrowEntity(EntityType<? extends AbstractArrow> type, Level level) {
        super(type, level);
        this.referenceStack = ItemStack.f_41583_;
    }

    public UpgradeArrowEntity(ArrowTier tier, Level level, double x, double y, double z, ItemStack stack) {
        super((EntityType)ModEntities.UPGRADE_ARROW.get(), x, y, z, level);
        this.referenceStack = stack;
        this.f_19804_.m_135381_(DATA_TIER, (Object)((byte)tier.ordinal()));
        CompoundTag tag = stack.m_41783_();
        int color = -1;
        if (tag != null && (tag.m_128441_("Potion") || tag.m_128441_("CustomPotionEffects") || tag.m_128441_("LingeringPotion"))) {
            color = OvergearedMod.ClientModEvents.getColor(stack);
        }
        this.f_19804_.m_135381_(DATA_POTION_COLOR, (Object)color);
        this.potion = UpgradeArrowEntity.getPotion(tag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TIER, (Object)((byte)ArrowTier.FLINT.ordinal()));
        this.f_19804_.m_135372_(DATA_POTION_COLOR, (Object)-1);
    }

    protected void m_5790_(EntityHitResult result) {
        this.m_36781_(this.m_36789_() * (double)this.getArrowTier().getDamageBonus());
        super.m_5790_(result);
    }

    protected void m_7761_(LivingEntity target) {
        LivingEntity livingOwner;
        super.m_7761_(target);
        Object owner = this.m_19749_();
        if (owner == null) {
            owner = this;
        }
        for (MobEffectInstance effect : this.potion.m_43488_()) {
            if (effect.m_19544_().m_8093_()) {
                effect.m_19544_().m_19461_(owner, (Entity)(owner instanceof LivingEntity ? (livingOwner = (LivingEntity)owner) : null), target, effect.m_19564_(), 1.0);
                continue;
            }
            MobEffectInstance reduced = new MobEffectInstance(effect.m_19544_(), Math.max(effect.m_19557_() / 8, 1), effect.m_19564_(), effect.m_19571_(), effect.m_19572_(), effect.m_19575_());
            target.m_147207_(reduced, owner);
        }
        for (MobEffectInstance effect : this.effects) {
            if (effect.m_19544_().m_8093_()) {
                effect.m_19544_().m_19461_(owner, (Entity)(owner instanceof LivingEntity ? (livingOwner = (LivingEntity)owner) : null), target, effect.m_19564_(), 1.0);
                continue;
            }
            target.m_147207_(effect, owner);
        }
    }

    protected void m_6532_(HitResult result) {
        CompoundTag tag;
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_ && (tag = this.referenceStack.m_41783_()) != null && (tag.m_128441_("LingeringPotion") || this.getArrowTier() == ArrowTier.FLINT && tag.m_128425_("Potion", 8))) {
            Potion potion = UpgradeArrowEntity.getPotion(tag);
            List<MobEffectInstance> effects = UpgradeArrowEntity.getAllEffects(tag);
            if (!effects.isEmpty()) {
                this.makeAreaOfEffectCloud(this.referenceStack, effects, result);
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
    }

    protected ItemStack m_7941_() {
        return switch (this.getArrowTier()) {
            default -> throw new IncompatibleClassChangeError();
            case ArrowTier.FLINT -> new ItemStack((ItemLike)Items.f_42412_);
            case ArrowTier.IRON -> new ItemStack((ItemLike)ModItems.IRON_UPGRADE_ARROW.get());
            case ArrowTier.STEEL -> new ItemStack((ItemLike)ModItems.STEEL_UPGRADE_ARROW.get());
            case ArrowTier.DIAMOND -> new ItemStack((ItemLike)ModItems.DIAMOND_UPGRADE_ARROW.get());
        };
    }

    private void multiplyDamage(double factor) {
        this.m_36781_(this.m_36789_() * factor);
    }

    public ArrowTier getArrowTier() {
        byte ordinal = (Byte)this.f_19804_.m_135370_(DATA_TIER);
        return ArrowTier.values()[ordinal % ArrowTier.values().length];
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("Tier", ((Byte)this.f_19804_.m_135370_(DATA_TIER)).byteValue());
        tag.m_128405_("PotionColor", ((Integer)this.f_19804_.m_135370_(DATA_POTION_COLOR)).intValue());
        if (!this.effects.isEmpty()) {
            ListTag listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            tag.m_128365_("CustomPotionEffects", (Tag)listtag);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Tier", 99)) {
            this.f_19804_.m_135381_(DATA_TIER, (Object)tag.m_128445_("Tier"));
        }
        if (tag.m_128425_("PotionColor", 99)) {
            this.f_19804_.m_135381_(DATA_POTION_COLOR, (Object)tag.m_128451_("PotionColor"));
        }
        this.effects.clear();
        for (MobEffectInstance mobeffectinstance : PotionUtils.m_43573_((CompoundTag)tag)) {
            this.addEffect(mobeffectinstance);
        }
    }

    public void addEffect(MobEffectInstance pEffectInstance) {
        this.effects.add(pEffectInstance);
        CompoundTag tag = this.referenceStack.m_41783_();
        Potion potion = UpgradeArrowEntity.getPotion(tag);
        this.m_20088_().m_135381_(DATA_POTION_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)potion, this.effects)));
    }

    private void makeAreaOfEffectCloud(ItemStack stack, List<MobEffectInstance> effects, HitResult result) {
        Vec3 hit = result.m_82450_();
        Vec3 motion = this.m_20184_();
        double verticalRatio = motion.f_82480_ / motion.m_82553_();
        double offset = verticalRatio > 0.0 ? -verticalRatio * 0.5 : -0.2;
        double cloudY = hit.f_82480_ + offset + 0.25;
        double cloudX = hit.f_82479_;
        double cloudZ = hit.f_82481_;
        AreaEffectCloud cloud = new AreaEffectCloud(this.m_9236_(), cloudX, cloudY, cloudZ);
        Entity owner = this.m_19749_();
        if (owner instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)owner;
            cloud.m_19718_(le);
        }
        cloud.m_19712_(3.0f);
        cloud.m_19732_(-0.5f);
        cloud.m_19740_(10);
        cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
        cloud.m_19722_(this.potion);
        for (MobEffectInstance inst : effects) {
            MobEffectInstance reducedEffect = new MobEffectInstance(inst.m_19544_(), Math.max(inst.m_19557_() / 8, 1), inst.m_19564_(), inst.m_19571_(), inst.m_19572_(), inst.m_19575_());
            cloud.m_19716_(reducedEffect);
        }
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_("CustomPotionColor", 99)) {
            cloud.m_19714_(compoundtag.m_128451_("CustomPotionColor"));
        }
        this.m_9236_().m_7967_((Entity)cloud);
    }

    public static List<MobEffectInstance> getMobEffects(ItemStack pStack) {
        return UpgradeArrowEntity.getAllEffects(pStack.m_41783_());
    }

    public static Potion getPotion(@Nullable CompoundTag tag) {
        if (tag == null) {
            return Potions.f_43598_;
        }
        if (tag.m_128425_("LingeringPotion", 8)) {
            return Potion.m_43489_((String)tag.m_128461_("LingeringPotion"));
        }
        if (tag.m_128441_("LingeringPotion") && tag.m_128471_("LingeringPotion")) {
            return Potion.m_43489_((String)tag.m_128461_("Potion"));
        }
        if (tag.m_128425_("Potion", 8)) {
            return Potion.m_43489_((String)tag.m_128461_("Potion"));
        }
        return Potions.f_43598_;
    }

    public static List<MobEffectInstance> getAllEffects(@Nullable CompoundTag pCompoundTag) {
        ArrayList list = Lists.newArrayList();
        list.addAll(UpgradeArrowEntity.getPotion(pCompoundTag).m_43488_());
        PotionUtils.m_43568_((CompoundTag)pCompoundTag, (List)list);
        return list;
    }

    public static void getCustomEffects(@Nullable CompoundTag pCompoundTag, List<MobEffectInstance> pEffectList) {
        if (pCompoundTag != null && pCompoundTag.m_128425_("CustomPotionEffects", 9)) {
            ListTag listtag = pCompoundTag.m_128437_("CustomPotionEffects", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                MobEffectInstance mobeffectinstance = MobEffectInstance.m_19560_((CompoundTag)compoundtag);
                if (mobeffectinstance == null) continue;
                pEffectList.add(mobeffectinstance);
            }
        }
    }

    private void makeParticle(int amount) {
        int color = (Integer)this.f_19804_.m_135370_(DATA_POTION_COLOR);
        if (color != -1 && amount > 0) {
            double r = (double)(color >> 16 & 0xFF) / 255.0;
            double g = (double)(color >> 8 & 0xFF) / 255.0;
            double b = (double)(color & 0xFF) / 255.0;
            for (int j = 0; j < amount; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), r, g, b);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.f_36703_) {
                if (this.f_36704_ % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        }
    }
}

