/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.networking.packet;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.stirdrem.overgeared.OvergearedMod;
import net.stirdrem.overgeared.client.ClientAnvilMinigameData;
import net.stirdrem.overgeared.event.ModItemInteractEvents;

public class MinigameSyncS2CPacket {
    private final CompoundTag minigameData;

    public MinigameSyncS2CPacket(CompoundTag minigameData) {
        this.minigameData = minigameData;
    }

    public MinigameSyncS2CPacket(FriendlyByteBuf buf) {
        this.minigameData = buf.m_130260_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.minigameData);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            if (this.minigameData == null) {
                OvergearedMod.LOGGER.error("Received null minigame data in packet");
                return;
            }
            try {
                ClientAnvilMinigameData.loadFromNBT(this.minigameData);
                ModItemInteractEvents.handleAnvilOwnershipSync(this.minigameData);
            }
            catch (Exception e) {
                OvergearedMod.LOGGER.error("Failed to process minigame sync packet", (Throwable)e);
            }
        });
        return true;
    }
}

