/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.recipe;

import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.stirdrem.overgeared.BlueprintQuality;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.recipe.ModRecipes;

public class BlueprintCloningRecipe
extends CustomRecipe {
    public BlueprintCloningRecipe(ResourceLocation pId, CraftingBookCategory pCategory) {
        super(pId, pCategory);
    }

    public boolean matches(CraftingContainer pInv, Level pLevel) {
        int blueprintCount = 0;
        ItemStack emptyBlueprint = ItemStack.f_41583_;
        for (int j = 0; j < pInv.m_6643_(); ++j) {
            ItemStack stack = pInv.m_8020_(j);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_((Item)ModItems.EMPTY_BLUEPRINT.get())) {
                if (!emptyBlueprint.m_41619_()) {
                    return false;
                }
                emptyBlueprint = stack;
                continue;
            }
            if (!stack.m_150930_((Item)ModItems.BLUEPRINT.get())) {
                return false;
            }
            ++blueprintCount;
        }
        return !emptyBlueprint.m_41619_() && blueprintCount > 0;
    }

    public ItemStack assemble(CraftingContainer pContainer, RegistryAccess pRegistryAccess) {
        String currentId;
        BlueprintQuality current;
        BlueprintQuality downgraded;
        ItemStack source = ItemStack.f_41583_;
        for (int j = 0; j < pContainer.m_6643_(); ++j) {
            ItemStack stack = pContainer.m_8020_(j);
            if (stack.m_41619_() || !stack.m_150930_((Item)ModItems.BLUEPRINT.get())) continue;
            if (!source.m_41619_()) {
                return ItemStack.f_41583_;
            }
            source = stack;
        }
        if (source.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = source.m_255036_(2);
        if (source.m_41782_() && source.m_41783_().m_128441_("Quality") && (downgraded = BlueprintQuality.getPrevious(current = BlueprintQuality.fromString(currentId = source.m_41783_().m_128461_("Quality")))) != null) {
            result.m_41784_().m_128359_("Quality", downgraded.getId());
        }
        return result;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth >= 3 && pHeight >= 3;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.CRAFTING_BLUEPRINTCLONING.get();
    }
}

