/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.stirdrem.overgeared.ForgingQuality;
import net.stirdrem.overgeared.config.ServerConfig;

public class OvergearedShapelessRecipe
extends ShapelessRecipe {
    private final NonNullList<IngredientWithRemainder> ingredientsWithRemainder;

    public OvergearedShapelessRecipe(ResourceLocation id, String group, CraftingBookCategory category, ItemStack result, NonNullList<IngredientWithRemainder> ingredientsWithRemainder) {
        super(id, group, category, result, OvergearedShapelessRecipe.convertToBaseIngredients(ingredientsWithRemainder));
        this.ingredientsWithRemainder = ingredientsWithRemainder;
    }

    private static NonNullList<Ingredient> convertToBaseIngredients(NonNullList<IngredientWithRemainder> customIngredients) {
        NonNullList baseIngredients = NonNullList.m_122779_();
        for (IngredientWithRemainder ingredient : customIngredients) {
            baseIngredients.add((Object)ingredient.getIngredient());
        }
        return baseIngredients;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList remainingItems = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        boolean[] ingredientProcessed = new boolean[this.ingredientsWithRemainder.size()];
        block0: for (int slot = 0; slot < container.m_6643_(); ++slot) {
            ItemStack slotStack = container.m_8020_(slot);
            if (slotStack.m_41619_()) continue;
            for (int ingIndex = 0; ingIndex < this.ingredientsWithRemainder.size(); ++ingIndex) {
                ItemStack remainder;
                if (ingredientProcessed[ingIndex] || !((IngredientWithRemainder)this.ingredientsWithRemainder.get(ingIndex)).getIngredient().test(slotStack)) continue;
                IngredientWithRemainder ingredient = (IngredientWithRemainder)this.ingredientsWithRemainder.get(ingIndex);
                if (ingredient.hasRemainder() && !(remainder = ingredient.getRemainder(slotStack)).m_41619_()) {
                    remainingItems.set(slot, (Object)remainder);
                }
                ingredientProcessed[ingIndex] = true;
                continue block0;
            }
        }
        return remainingItems;
    }

    public ItemStack m_5874_(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack result = super.m_5874_(container, registryAccess);
        if (!((Boolean)ServerConfig.ENABLE_MINIGAME.get()).booleanValue()) {
            boolean hasUnpolishedQualityItem = false;
            boolean unquenched = false;
            String foundQuality = null;
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack ingredient = container.m_8020_(i);
                if (!ingredient.m_41782_()) continue;
                CompoundTag tag = ingredient.m_41783_();
                if (!tag.m_128441_("Polished") || !tag.m_128471_("Polished")) {
                    hasUnpolishedQualityItem = true;
                    break;
                }
                if (tag.m_128441_("Heated") && tag.m_128471_("Heated")) {
                    unquenched = true;
                    break;
                }
                if (!tag.m_128441_("ForgingQuality")) continue;
                foundQuality = tag.m_128461_("ForgingQuality");
            }
            if (hasUnpolishedQualityItem || unquenched) {
                return ItemStack.f_41583_;
            }
            CompoundTag resultTag = result.m_41784_();
            ForgingQuality quality = ForgingQuality.fromString(foundQuality);
            resultTag.m_128359_("ForgingQuality", quality.getDisplayName());
            result.m_41751_(resultTag);
            return result;
        }
        CompoundTag resultTag = result.m_41784_();
        String foundQuality = null;
        boolean isPolished = false;
        boolean unquenched = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack ingredient = container.m_8020_(i);
            if (!ingredient.m_41782_()) continue;
            CompoundTag tag = ingredient.m_41783_();
            if (tag.m_128441_("ForgingQuality")) {
                foundQuality = tag.m_128461_("ForgingQuality");
            }
            if (tag.m_128441_("Polished") && tag.m_128471_("Polished")) {
                isPolished = true;
            }
            if (!tag.m_128441_("Heated") || !tag.m_128471_("Heated")) continue;
            unquenched = true;
        }
        if (foundQuality != null) {
            ForgingQuality quality = ForgingQuality.fromString(foundQuality);
            if (!isPolished) {
                quality = quality.getLowerQuality();
            }
            if (unquenched) {
                quality = quality.getLowerQuality();
            }
            resultTag.m_128359_("ForgingQuality", quality.getDisplayName());
            result.m_41751_(resultTag);
        } else if (unquenched) {
            return ItemStack.f_41583_;
        }
        return result;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public static class IngredientWithRemainder {
        private final Ingredient ingredient;
        private final boolean remainder;
        private final int durabilityDecrease;

        public IngredientWithRemainder(Ingredient ingredient, boolean remainder, int durabilityDecrease) {
            this.ingredient = ingredient;
            this.remainder = remainder;
            this.durabilityDecrease = durabilityDecrease;
        }

        public static IngredientWithRemainder fromNetwork(FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            boolean remainder = buffer.readBoolean();
            int durabilityDecrease = buffer.readInt();
            return new IngredientWithRemainder(ingredient, remainder, durabilityDecrease);
        }

        public Ingredient getIngredient() {
            return this.ingredient;
        }

        public boolean hasRemainder() {
            return this.remainder;
        }

        public int getDurabilityDecrease() {
            return this.durabilityDecrease;
        }

        public ItemStack getRemainder(ItemStack original) {
            if (!this.remainder) {
                return ItemStack.f_41583_;
            }
            ItemStack remainderStack = original.m_41777_();
            remainderStack.m_41764_(1);
            if (this.durabilityDecrease > 0 && remainderStack.m_41763_()) {
                int newDamage = remainderStack.m_41773_() + this.durabilityDecrease;
                if (newDamage >= remainderStack.m_41776_()) {
                    return ItemStack.f_41583_;
                }
                remainderStack.m_41721_(newDamage);
            }
            return remainderStack;
        }

        public void toNetwork(FriendlyByteBuf buffer) {
            this.ingredient.m_43923_(buffer);
            buffer.writeBoolean(this.remainder);
            buffer.writeInt(this.durabilityDecrease);
        }
    }

    public static class Serializer
    implements RecipeSerializer<OvergearedShapelessRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public OvergearedShapelessRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = json.has("group") ? json.get("group").getAsString() : "";
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", (String)"misc"), (Enum)CraftingBookCategory.MISC);
            JsonObject resultJson = json.getAsJsonObject("result");
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)resultJson);
            JsonArray ingredientsJson = json.getAsJsonArray("ingredients");
            NonNullList ingredients = NonNullList.m_122779_();
            for (JsonElement element : ingredientsJson) {
                JsonObject ingredientJson = element.getAsJsonObject();
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientJson);
                boolean remainder = ingredientJson.has("remainder") && ingredientJson.get("remainder").getAsBoolean();
                int durabilityDecrease = ingredientJson.has("durability_decrease") ? ingredientJson.get("durability_decrease").getAsInt() : 0;
                ingredients.add((Object)new IngredientWithRemainder(ingredient, remainder, durabilityDecrease));
            }
            return new OvergearedShapelessRecipe(recipeId, group, category, result, (NonNullList<IngredientWithRemainder>)ingredients);
        }

        public OvergearedShapelessRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            CraftingBookCategory category = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            ItemStack result = buffer.m_130267_();
            int ingredientCount = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122779_();
            for (int i = 0; i < ingredientCount; ++i) {
                ingredients.add((Object)IngredientWithRemainder.fromNetwork(buffer));
            }
            return new OvergearedShapelessRecipe(recipeId, group, category, result, (NonNullList<IngredientWithRemainder>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, OvergearedShapelessRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.m_245232_());
            buffer.m_130055_(recipe.m_8043_(null));
            buffer.m_130130_(recipe.ingredientsWithRemainder.size());
            for (IngredientWithRemainder ingredient : recipe.ingredientsWithRemainder) {
                ingredient.toNetwork(buffer);
            }
        }
    }

    public static class Type
    implements RecipeType<OvergearedShapelessRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "crafting_shapeless";
    }
}

