/*
 * Decompiled with CFR 0.152.
 */
package net.le0nia.inconsistentize.mixin;

import java.util.List;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin {
    @Shadow
    private int pickupDelay;
    @Shadow
    @Nullable
    private UUID target;

    @Shadow
    public abstract ItemStack getItem();

    @Inject(method={"playerTouch"}, at={@At(value="HEAD")}, cancellable=true)
    private void init(CallbackInfo info) {
        info.cancel();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        ItemEntity self = (ItemEntity)this;
        if (self.level().isClientSide()) {
            return;
        }
        List players = self.level().getEntitiesOfClass(Player.class, self.getBoundingBox().inflate(1.0, 0.5, 1.0), p -> p.isAlive() && !p.isSpectator());
        long seed = (long)self.getId() << 32 ^ self.level().getGameTime();
        RandomSource rng = RandomSource.create((long)seed);
        Util.shuffle((List)players, (RandomSource)rng);
        for (Player p2 : players) {
            if (!p2.getBoundingBox().inflate(1.0, 0.5, 1.0).intersects(self.getBoundingBox())) continue;
            ItemStack stack = this.getItem();
            if (stack.isEmpty()) break;
            if (this.pickupDelay != 0 || this.target != null && !this.target.equals(p2.getUUID())) continue;
            int countBefore = stack.getCount();
            Item item = stack.getItem();
            if (!p2.getInventory().add(stack)) continue;
            p2.take((Entity)self, countBefore);
            if (stack.isEmpty()) {
                self.discard();
                stack.setCount(countBefore);
            }
            p2.awardStat(Stats.ITEM_PICKED_UP.get((Object)item), countBefore);
            p2.onItemPickup(self);
            break;
        }
    }
}

