/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.obese_crops.common.resourcereloader;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.macuguita.obese_crops.common.ObeseCrops;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class ObeseMapResourceReloadListener
implements SimpleSynchronousResourceReloadListener {
    public static final class_2960 ID = ObeseCrops.id("obese_block_map_reload_listener");
    private static final class_2960 OBESE_MAP_DIR = ObeseCrops.id("obese_map");

    public void method_14491(@NotNull class_3300 manager) {
        ObeseCrops.OBESE_MAP.clear();
        manager.method_41265(OBESE_MAP_DIR.method_12832(), path -> path.method_12836().equals("obese_crops") && path.method_12832().endsWith(".json")).forEach((identifier, resources) -> {
            for (class_3298 resource : resources) {
                try {
                    InputStream stream = resource.method_14482();
                    try {
                        JsonObject object = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new InputStreamReader(stream))).getAsJsonObject();
                        class_2960 cropBlockId = class_2960.method_60654((String)identifier.method_12832().substring(identifier.method_12832().indexOf("/") + 1, identifier.method_12832().length() - 5).replace("/", ":"));
                        class_2248 cropBlock = (class_2248)class_7923.field_41175.method_10223(cropBlockId);
                        if (cropBlock == class_7923.field_41175.method_10223(class_7923.field_41175.method_10137()) && !cropBlockId.equals((Object)class_7923.field_41175.method_10137())) continue;
                        DataResult data = ObeseBlockData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)object);
                        data.resultOrPartial(error -> ObeseCrops.LOGGER.error("Failed to parse obese crop '{} in file '{}'", (Object)cropBlockId, error)).ifPresent(obeseBlockData -> ObeseCrops.OBESE_MAP.put(cropBlock, (ObeseBlockData)obeseBlockData));
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception exception) {
                    ObeseCrops.LOGGER.error("{} in file '{}'", (Object)exception.getLocalizedMessage(), identifier);
                }
            }
        });
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public record ObeseBlockData(BlockAndChance primary, List<BlockAndChance> secondaries) {
        private static final Codec<ObeseBlockData> COMPLEX_CODEC = RecordCodecBuilder.create(i -> i.group((App)BlockAndChance.CODEC.fieldOf("primary").forGetter(ObeseBlockData::primary), (App)BlockAndChance.CODEC.listOf().fieldOf("secondaries").forGetter(ObeseBlockData::secondaries)).apply((Applicative)i, ObeseBlockData::new));
        private static final Codec<ObeseBlockData> SIMPLE_CODEC = RecordCodecBuilder.create(i -> i.group((App)BlockAndChance.CODEC.fieldOf("primary").forGetter(ObeseBlockData::primary)).apply((Applicative)i, blockAndChance -> new ObeseBlockData((BlockAndChance)blockAndChance, Collections.emptyList())));
        public static final Codec<ObeseBlockData> CODEC = Codec.either(COMPLEX_CODEC, SIMPLE_CODEC).xmap(either -> (ObeseBlockData)either.map(data -> data, data -> data), data -> data.secondaries().isEmpty() ? Either.right((Object)data) : Either.left((Object)data));

        public record BlockAndChance(class_2248 block, class_2248 foliage, int chance) {
            public static final Codec<class_2248> BLOCK_CODEC = class_2960.field_25139.flatXmap(rl -> {
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(rl);
                if (!class_7923.field_41175.method_10250(rl)) {
                    return DataResult.error(() -> "Unknown block: " + String.valueOf(rl));
                }
                return DataResult.success((Object)block);
            }, block -> DataResult.success((Object)class_7923.field_41175.method_10221(block)));
            public static final Codec<BlockAndChance> CODEC = RecordCodecBuilder.create(i -> i.group((App)BLOCK_CODEC.fieldOf("block").forGetter(BlockAndChance::block), (App)BLOCK_CODEC.fieldOf("foliage").forGetter(BlockAndChance::foliage), (App)Codec.INT.fieldOf("chance").forGetter(BlockAndChance::chance)).apply((Applicative)i, BlockAndChance::new));
        }
    }
}

