/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.obese_crops.datagen;

import com.macuguita.obese_crops.common.reg.OCEnchantments;
import com.macuguita.obese_crops.common.reg.OCObjects;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OCLangProvider
extends FabricLanguageProvider {
    public OCLangProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, "en_us", registryLookup);
    }

    public void generateTranslations(class_7225.class_7874 wrapperLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.generateBlockTranslations(translationBuilder, (class_2248)OCObjects.OBESE_APPLE.get());
        this.generateBlockTranslations(translationBuilder, (class_2248)OCObjects.OBESE_BEETROOT.get());
        this.generateBlockTranslations(translationBuilder, (class_2248)OCObjects.OBESE_CARROT.get());
        this.generateBlockTranslations(translationBuilder, (class_2248)OCObjects.OBESE_POISONOUS_POTATO.get());
        this.generateBlockTranslations(translationBuilder, (class_2248)OCObjects.OBESE_POTATO.get());
        OCObjects.SCYTHE_ITEMS.stream().forEach(item -> this.generateItemTranslations(translationBuilder, (class_1792)item.get()));
        translationBuilder.add("itemGroup.obese_crops.obese_crops", "Obese Crops");
        this.generateEnchantmentTranslations(translationBuilder, OCEnchantments.BOUNTIFUL_REAP);
        this.generateEnchantmentDescriptionTranslations(translationBuilder, OCEnchantments.BOUNTIFUL_REAP, "Allows you scythe to reap in a bigger area.");
    }

    @Contract(value="_ -> new")
    @NotNull
    private String capitalizeString(@NotNull String string) {
        char[] chars = string.toLowerCase(Locale.getDefault()).toCharArray();
        boolean found = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!found && Character.isLetter(chars[i])) {
                chars[i] = Character.toUpperCase(chars[i]);
                found = true;
                continue;
            }
            if (!Character.isWhitespace(chars[i]) && chars[i] != '.' && chars[i] != '\'') continue;
            found = false;
        }
        return new String(chars);
    }

    private void generateBlockTranslations(@NotNull FabricLanguageProvider.TranslationBuilder translationBuilder, class_2248 block) {
        String temp = this.capitalizeString(class_7923.field_41175.method_10221((Object)block).method_12832().replace("_", " "));
        translationBuilder.add(block, temp);
    }

    private void generateItemTranslations(@NotNull FabricLanguageProvider.TranslationBuilder translationBuilder, class_1792 item) {
        String temp = this.capitalizeString(class_7923.field_41178.method_10221((Object)item).method_12832().replace("_", " "));
        translationBuilder.add(item, temp);
    }

    private void generateEnchantmentTranslations(@NotNull FabricLanguageProvider.TranslationBuilder translationBuilder, @NotNull class_5321<class_1887> enchantment) {
        String temp = this.capitalizeString(enchantment.method_29177().method_12832().replace("_", " "));
        translationBuilder.add("enchantment." + enchantment.method_29177().method_12836() + "." + enchantment.method_29177().method_12832(), temp);
    }

    private void generateEnchantmentDescriptionTranslations(@NotNull FabricLanguageProvider.TranslationBuilder translationBuilder, @NotNull class_5321<class_1887> enchantment, String description) {
        translationBuilder.add("enchantment." + enchantment.method_29177().method_12836() + "." + enchantment.method_29177().method_12832() + ".desc", description);
    }
}

