/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.content.data.powers.armors;

import java.util.Iterator;
import java.util.List;
import net.bexla.orevolution.content.data.Conditionals;
import net.bexla.orevolution.content.types.OrevolutionArmorPower;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ArmorMultiPower
extends OrevolutionArmorPower {
    private final List<OrevolutionArmorPower> powers;

    public ArmorMultiPower(List<OrevolutionArmorPower> powers) {
        super("", Conditionals.always());
        this.powers = powers;
    }

    @Override
    public List<Component> appendTooltip(ItemStack stack, Level level, List<Component> lines) {
        Iterator<OrevolutionArmorPower> iterator = this.powers.iterator();
        if (iterator.hasNext()) {
            OrevolutionArmorPower p = iterator.next();
            return p.appendTooltip(stack, level, lines);
        }
        return List.of();
    }

    @Override
    public void onTickWhileWorn(ItemStack stack, LivingEntity wearer, EquipmentSlot slot) {
        for (OrevolutionArmorPower p : this.powers) {
            p.onTickWhileWorn(stack, wearer, slot);
        }
    }

    @Override
    public void onAttacked(LivingEntity wearer, DamageSource source, float amount) {
        for (OrevolutionArmorPower p : this.powers) {
            p.onAttacked(wearer, source, amount);
        }
    }

    @Override
    public void onAttackTarget(LivingEntity wearer, LivingEntity target) {
        for (OrevolutionArmorPower p : this.powers) {
            p.onAttackTarget(wearer, target);
        }
    }

    @Override
    public boolean onDeath(LivingEntity wearer, LivingEntity killer) {
        Iterator<OrevolutionArmorPower> iterator = this.powers.iterator();
        if (iterator.hasNext()) {
            OrevolutionArmorPower p = iterator.next();
            return p.onDeath(wearer, killer);
        }
        return false;
    }

    @Override
    public boolean onFall(LivingEntity wearer, float distance, float damageMultiplier) {
        Iterator<OrevolutionArmorPower> iterator = this.powers.iterator();
        if (iterator.hasNext()) {
            OrevolutionArmorPower p = iterator.next();
            return p.onFall(wearer, distance, damageMultiplier);
        }
        return false;
    }

    @Override
    public void onKnockback(LivingEntity wearer, float strength, double ratioX, double ratioZ) {
        for (OrevolutionArmorPower p : this.powers) {
            p.onKnockback(wearer, strength, ratioX, ratioZ);
        }
    }
}

