/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.content.data.powers.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.bexla.orevolution.content.types.OrevolutionToolPower;
import net.bexla.orevolution.content.types.TierProgressRegistry;
import net.bexla.orevolution.content.types.interfaces.Conditional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ToolAddEffectPerBlockAmount
extends OrevolutionToolPower {
    private final int minimalBlocks;
    private final Supplier<MobEffect> effect;
    private final int effectTime;
    private final int maxStacks;

    public ToolAddEffectPerBlockAmount(String id, Conditional condition, Supplier<MobEffect> effect, int minBlocks, int minEffectTime, int maxStacks) {
        super(id, condition);
        this.minimalBlocks = minBlocks;
        this.effect = effect;
        this.effectTime = minEffectTime;
        this.maxStacks = maxStacks;
    }

    @Override
    public List<Component> appendTooltip(ItemStack stack, Level level, List<Component> lines) {
        ArrayList<Component> tips = new ArrayList<Component>();
        tips.add((Component)Component.m_237110_((String)("tooltip.orevolution." + this.getTooltipID()), (Object[])new Object[]{this.minimalBlocks}).m_130940_(ChatFormatting.GREEN));
        tips.add((Component)Component.m_237113_((String)(" - " + this.effect.get().m_19482_().getString())).m_130940_(ChatFormatting.AQUA));
        return tips;
    }

    @Override
    public void onMineBlock(ItemStack stack, Level level, BlockPos pos, LivingEntity player, BlockState state) {
        TieredItem tieredItem;
        if (!this.getCondition(stack, state, level, player, null)) {
            return;
        }
        MobEffect eff = this.effect.get();
        Item item = stack.m_41720_();
        if (item instanceof TieredItem && TierProgressRegistry.isCorrectTierForDrops((tieredItem = (TieredItem)item).m_43314_(), state)) {
            int effectsStacked;
            int blocksMined = stack.m_41784_().m_128451_("blocksMined");
            MobEffectInstance currentEffect = player.m_21124_(eff);
            int n = effectsStacked = currentEffect != null ? currentEffect.m_19564_() : 0;
            if (++blocksMined >= this.minimalBlocks + effectsStacked) {
                if (effectsStacked < this.maxStacks) {
                    int newDuration = this.effectTime * effectsStacked;
                    player.m_21195_(eff);
                    player.m_7292_(new MobEffectInstance(eff, newDuration, effectsStacked, false, true));
                }
                blocksMined = 0;
            }
            stack.m_41784_().m_128405_("blocksMined", blocksMined);
        }
    }
}

