/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.content.types.providers;

import com.teamabnormals.blueprint.core.data.client.BlueprintItemModelProvider;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class ItemModelProvider
extends BlueprintItemModelProvider {
    public ItemModelProvider(PackOutput output, ExistingFileHelper help) {
        super(output, "orevolution", help);
    }

    protected String blockName(Supplier<? extends Block> block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block.get()).m_135815_();
    }

    private ResourceLocation blockTexture(Supplier<? extends Block> block) {
        return ItemModelProvider.key((ItemLike)((ItemLike)block.get())).m_246208_("block/");
    }

    public ItemModelBuilder block(Supplier<? extends Block> block) {
        return this.block(block, this.blockName(block));
    }

    public ItemModelBuilder block(Supplier<? extends Block> block, String name) {
        return (ItemModelBuilder)this.withExistingParent(this.blockName(block), this.modLoc("block/" + name));
    }

    public ItemModelBuilder blockFlat(Supplier<? extends Block> block) {
        return this.blockFlat(block, this.blockName(block));
    }

    public ItemModelBuilder blockFlat(Supplier<? extends Block> block, Supplier<? extends Block> fullBlock) {
        return this.blockFlat(block, this.blockName(fullBlock));
    }

    public ItemModelBuilder generated(String name, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, this.mcLoc("item/generated"))).texture("layer0", texture);
    }

    public ItemModelBuilder generated(Supplier<? extends ItemLike> itemLike, ResourceLocation texture) {
        return this.generated(ItemModelProvider.name((ItemLike)itemLike.get()), texture);
    }

    public ItemModelBuilder blockFlat(Supplier<? extends Block> block, String name) {
        return this.generated(block, this.modLoc("block/" + name));
    }

    public ItemModelBuilder normalItem(Supplier<? extends Item> item, String subfolder) {
        return this.generated(item, ItemModelProvider.itemTex((ItemLike)item.get(), subfolder));
    }

    public static ResourceLocation itemTex(ItemLike item, String subfolder) {
        ResourceLocation name = ItemModelProvider.key((ItemLike)item);
        return new ResourceLocation(name.m_135827_(), "item/" + subfolder + "/" + name.m_135815_());
    }

    public ItemModelBuilder toolItem(Supplier<? extends Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item.get()).m_135815_(), this.mcLoc("item/handheld"))).texture("layer0", ItemModelProvider.itemTex((ItemLike)item.get(), "tool"));
    }

    public ItemModelBuilder wall(Supplier<? extends Block> wall, Supplier<? extends Block> fullBlock) {
        return (ItemModelBuilder)this.wallInventory(ForgeRegistries.BLOCKS.getKey((Object)wall.get()).m_135815_(), ItemModelProvider.key((ItemLike)((ItemLike)fullBlock.get())).m_246208_("block/decorative/"));
    }
}

