/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.events;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.bexla.orevolution.OrevolutionConfig;
import net.bexla.orevolution.content.data.utility.OrevolutionUtils;
import net.bexla.orevolution.content.types.ArmorPowerRegistry;
import net.bexla.orevolution.content.types.interfaces.ArmorPower;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber
public class OrevolutionArmorPowersSubscriber {
    private static final Logger LOGGER = LogUtils.getLogger();

    private static void withArmorPower(LivingEntity entity, Consumer<ArmorPower> action) {
        if (!((Boolean)OrevolutionConfig.COMMON.armorsPowers.get()).booleanValue()) {
            return;
        }
        ItemStack helmet = entity.m_6844_(EquipmentSlot.HEAD);
        Item helItem = helmet.m_41720_();
        ArmorPower singularPower = ArmorPowerRegistry.getItemPower(() -> helItem);
        if (singularPower != ArmorPower.EMPTY) {
            action.accept(singularPower);
        }
        if (!(helItem instanceof ArmorItem)) {
            return;
        }
        ArmorItem armorItem = (ArmorItem)helItem;
        ArmorMaterial material = armorItem.m_40401_();
        if (!OrevolutionUtils.isWearingFullSet(entity, material)) {
            return;
        }
        ArmorPower power = ArmorPowerRegistry.getPower(material);
        if (power != ArmorPower.EMPTY) {
            action.accept(power);
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        OrevolutionArmorPowersSubscriber.withArmorPower(event.getEntity(), power -> power.onTickWhileWorn(event.getEntity().m_6844_(EquipmentSlot.HEAD), event.getEntity(), EquipmentSlot.HEAD));
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        OrevolutionArmorPowersSubscriber.withArmorPower(event.getEntity(), power -> power.onAttacked(event.getEntity(), event.getSource(), event.getAmount()));
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        OrevolutionArmorPowersSubscriber.withArmorPower(event.getEntity(), power -> {
            Entity patt2794$temp = event.getSource().m_7639_();
            if (patt2794$temp instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)patt2794$temp;
                power.onAttackTarget(event.getEntity(), attacker);
            }
        });
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        OrevolutionArmorPowersSubscriber.withArmorPower(event.getEntity(), power -> power.onFall(event.getEntity(), event.getDistance(), event.getDamageMultiplier()));
    }

    @SubscribeEvent
    public static void onKnockback(LivingKnockBackEvent event) {
        OrevolutionArmorPowersSubscriber.withArmorPower(event.getEntity(), power -> power.onKnockback(event.getEntity(), event.getStrength(), event.getRatioX(), event.getRatioZ()));
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        OrevolutionArmorPowersSubscriber.withArmorPower(event.getEntity(), power -> {
            Entity patt3620$temp = event.getSource().m_7639_();
            if (patt3620$temp instanceof LivingEntity) {
                LivingEntity killer = (LivingEntity)patt3620$temp;
                event.setCanceled(power.onDeath(event.getEntity(), killer));
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (!((Boolean)OrevolutionConfig.CLIENT.armorsPowersTip.get()).booleanValue()) {
            return;
        }
        ArrayList<Object> tip = new ArrayList<Object>();
        Player entity = event.getEntity();
        if (entity == null) {
            return;
        }
        List tooltip = event.getToolTip();
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (!(item instanceof ArmorItem)) {
            return;
        }
        ArmorItem item2 = (ArmorItem)item;
        Item helmet = entity.m_6844_(EquipmentSlot.HEAD).m_41720_();
        ArmorPower singularPower = ArmorPowerRegistry.getItemPower(() -> helmet);
        if (singularPower != ArmorPower.EMPTY) {
            tip.addAll(singularPower.appendTooltip(stack, entity.m_9236_(), tooltip));
        }
        ArmorMaterial material = item2.m_40401_();
        if (item2.m_266204_() != ArmorItem.Type.HELMET && item2.m_266204_() != ArmorItem.Type.CHESTPLATE && item2.m_266204_() != ArmorItem.Type.LEGGINGS && item2.m_266204_() != ArmorItem.Type.BOOTS) {
            return;
        }
        ArmorPower power = ArmorPowerRegistry.getPower(material);
        if (power != ArmorPower.EMPTY) {
            tip.add(0, Component.m_237115_((String)"tooltip.orevolution.full_set_bonus"));
            tip.addAll(power.appendTooltip(stack, entity.m_9236_(), tooltip));
        }
        tooltip.addAll(1, tip);
    }
}

