/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.init;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.bexla.orevolution.OrevolutionConfig;
import net.bexla.orevolution.compatibility.ModCompat;
import net.bexla.orevolution.compatibility.spelunkery.RegBlocksSK;
import net.bexla.orevolution.content.data.utility.OreType;
import net.bexla.orevolution.content.data.utility.OrevolutionUtils;
import net.bexla.orevolution.content.types.features.MeteoriteFeature;
import net.bexla.orevolution.content.types.features.OreConditionalFeature;
import net.bexla.orevolution.init.RegBlocks;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class RegFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"orevolution");
    public static final RegistryObject<Feature<OreConfiguration>> TIN_ORE = FEATURES.register("tin_ore_feature", () -> new OreConditionalFeature((Codec<OreConfiguration>)OreConfiguration.f_67837_, (Supplier<Boolean>)OrevolutionConfig.COMMON.generateTinOre));
    public static final RegistryObject<Feature<OreConfiguration>> PLATINUM_ORE = FEATURES.register("platinum_ore_feature", () -> new OreConditionalFeature((Codec<OreConfiguration>)OreConfiguration.f_67837_, (Supplier<Boolean>)OrevolutionConfig.COMMON.generatePlatOre));
    public static final RegistryObject<Feature<OreConfiguration>> TIN_ORE_SK = FEATURES.register("tin_ore_spelunkery_feature", () -> new OreConditionalFeature((Codec<OreConfiguration>)OreConfiguration.f_67837_, () -> (Boolean)OrevolutionConfig.COMMON.generateTinOre.get() != false && ModCompat.isModLoaded(ModCompat.SPELUNKERY)));
    public static final RegistryObject<Feature<OreConfiguration>> PLATINUM_ORE_SK = FEATURES.register("platinum_ore_spelunkery_feature", () -> new OreConditionalFeature((Codec<OreConfiguration>)OreConfiguration.f_67837_, () -> (Boolean)OrevolutionConfig.COMMON.generatePlatOre.get() != false && ModCompat.isModLoaded(ModCompat.SPELUNKERY)));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> METEORITE = FEATURES.register("meteorite_feature", () -> new MeteoriteFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));

    public static final class Placed {
        public static final Map<String, ResourceKey<PlacedFeature>> ALL = new HashMap<String, ResourceKey<PlacedFeature>>();

        private static ResourceKey<PlacedFeature> create(String name) {
            return ALL.computeIfAbsent(name, n -> ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)OrevolutionUtils.modLocat(n)));
        }

        public static void bootstrap(BootstapContext<PlacedFeature> ctx) {
            HolderGetter features = ctx.m_255420_(Registries.f_256911_);
            Placed.registerOrePlacement(ctx, features, "tin_ore", 10, 0, 110);
            Placed.registerOrePlacement(ctx, features, "tin_ore_extra", 10, 62, 320);
            Placed.registerOrePlacement(ctx, features, "platinum_ore", 7, -20, 53);
            Placed.registerOrePlacement(ctx, features, "platinum_ore_extra", 7, 42, 128);
            Placed.registerRareOrePlacement(ctx, features, "tungsten_ore", 6, -30, 33);
            Placed.registerOrePlacement(ctx, features, "tungsten_ore_extra", 8, -160, 0);
            Placed.registerMeteoritePlacementTop(ctx, features, "meteorite_high", 120, 180);
            Placed.registerMeteoritePlacementRange(ctx, features, "meteorite_low", 210, 95, 140);
            Placed.registerOrePlacement(ctx, features, "tin_ore_spelunkery", 9, 0, 110);
            Placed.registerOrePlacement(ctx, features, "platinum_ore_spelunkery", 6, -20, 53);
        }

        private static void registerMeteoritePlacementTop(BootstapContext<PlacedFeature> ctx, HolderGetter<ConfiguredFeature<?, ?>> features, String name, int rarity, int minY) {
            ctx.m_255272_(Placed.create(name), (Object)new PlacedFeature((Holder)features.m_255043_(Configured.ALL.get(name)), Placed.rareOrePlacement(rarity, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)minY), (VerticalAnchor)VerticalAnchor.m_158929_()))));
        }

        private static void registerMeteoritePlacementRange(BootstapContext<PlacedFeature> ctx, HolderGetter<ConfiguredFeature<?, ?>> features, String name, int rarity, int minY, int maxY) {
            ctx.m_255272_(Placed.create(name), (Object)new PlacedFeature((Holder)features.m_255043_(Configured.ALL.get(name)), Placed.rareOrePlacement(rarity, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)minY), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxY)))));
        }

        private static void registerOrePlacement(BootstapContext<PlacedFeature> ctx, HolderGetter<ConfiguredFeature<?, ?>> features, String name, int count, int minY, int maxY) {
            ctx.m_255272_(Placed.create(name), (Object)new PlacedFeature((Holder)features.m_255043_(Configured.ALL.get(name)), Placed.commonOrePlacement(count, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)minY), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxY)))));
        }

        private static void registerRareOrePlacement(BootstapContext<PlacedFeature> ctx, HolderGetter<ConfiguredFeature<?, ?>> features, String name, int count, int minY, int maxY) {
            ctx.m_255272_(Placed.create(name), (Object)new PlacedFeature((Holder)features.m_255043_(Configured.ALL.get(name)), Placed.rareOrePlacement(count, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)minY), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxY)))));
        }

        private static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
            return List.of(p_195347_, InSquarePlacement.m_191715_(), p_195348_, BiomeFilter.m_191561_());
        }

        private static List<PlacementModifier> commonOrePlacement(int p_195344_, PlacementModifier p_195345_) {
            return Placed.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)p_195344_), p_195345_);
        }

        private static List<PlacementModifier> rareOrePlacement(int p_195350_, PlacementModifier p_195351_) {
            return Placed.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)p_195350_), p_195351_);
        }
    }

    public static final class Configured {
        public static final Map<String, ResourceKey<ConfiguredFeature<?, ?>>> ALL = new HashMap();
        public static final List<Block> TIN_ORES = List.of((Block)RegBlocks.TIN_ORE.get(), (Block)RegBlocks.DEEPSLATE_TIN_ORE.get());
        public static final List<Block> PLATINUM_ORES = List.of((Block)RegBlocks.PLATINUM_ORE.get(), (Block)RegBlocks.DEEPSLATE_PLATINUM_ORE.get());
        public static final List<Block> TIN_ORES_SK = List.of((Block)RegBlocksSK.TIN_ORE_TUFF.get(), (Block)RegBlocksSK.TIN_ORE_ANDESITE.get(), (Block)RegBlocksSK.TIN_ORE_GRANITE.get(), (Block)RegBlocksSK.TIN_ORE_DIORITE.get());
        public static final List<Block> PLATINUM_ORES_SK = List.of((Block)RegBlocksSK.PLATINUM_ORE_TUFF.get(), (Block)RegBlocksSK.PLATINUM_ORE_ANDESITE.get(), (Block)RegBlocksSK.PLATINUM_ORE_GRANITE.get(), (Block)RegBlocksSK.PLATINUM_ORE_DIORITE.get());

        private static ResourceKey<ConfiguredFeature<?, ?>> create(String name) {
            return ALL.computeIfAbsent(name, n -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)OrevolutionUtils.modLocat(n)));
        }

        public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> ctx) {
            Configured.registerTinOre(ctx, "tin_ore", OreType.OVERWORLD, TIN_ORES, 13, 0.0f, OrevolutionConfig.COMMON.generateTinOre);
            Configured.registerTinOre(ctx, "tin_ore_extra", OreType.OVERWORLD, TIN_ORES, 12, 0.0f, OrevolutionConfig.COMMON.generateTinOre);
            Configured.registerPlatinumOre(ctx, "platinum_ore", OreType.OVERWORLD, PLATINUM_ORES, 8, 0.2f, OrevolutionConfig.COMMON.generatePlatOre);
            Configured.registerPlatinumOre(ctx, "platinum_ore_extra", OreType.OVERWORLD, PLATINUM_ORES, 7, 0.3f, OrevolutionConfig.COMMON.generatePlatOre);
            Configured.registerSpelunkeryTinOre(ctx, "tin_ore_spelunkery", OreType.OVERWORLD_SPELUNKERY, TIN_ORES_SK, 13, 0.0f, () -> (Boolean)OrevolutionConfig.COMMON.generateTinOre.get() != false && ModCompat.isModLoaded(ModCompat.SPELUNKERY));
            Configured.registerSpelunkeryPlatinumOre(ctx, "platinum_ore_spelunkery", OreType.OVERWORLD_SPELUNKERY, PLATINUM_ORES_SK, 8, 0.2f, () -> (Boolean)OrevolutionConfig.COMMON.generatePlatOre.get() != false && ModCompat.isModLoaded(ModCompat.SPELUNKERY));
            Configured.registerOre(ctx, "tungsten_ore", OreType.NETHER, List.of((Block)RegBlocks.NETHER_TUNGSTEN_ORE.get()), 4, 0.95f);
            Configured.registerOre(ctx, "tungsten_ore_extra", OreType.NETHER, List.of((Block)RegBlocks.NETHER_TUNGSTEN_ORE.get()), 6, 1.0f);
            ctx.m_255272_(Configured.create("meteorite_high"), (Object)new ConfiguredFeature((Feature)METEORITE.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
            ctx.m_255272_(Configured.create("meteorite_low"), (Object)new ConfiguredFeature((Feature)METEORITE.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
        }

        private static void registerTinOre(BootstapContext<ConfiguredFeature<?, ?>> ctx, String name, OreType type, List<Block> variants, int size, float discardChance, Supplier<Boolean> condition) {
            ResourceKey<ConfiguredFeature<?, ?>> key = Configured.create(name);
            ArrayList<OreConfiguration.TargetBlockState> targets = new ArrayList<OreConfiguration.TargetBlockState>();
            for (int i = 0; i < Math.min(type.getTargets().size(), variants.size()); ++i) {
                targets.add(OreConfiguration.m_161021_((RuleTest)((RuleTest)type.getTargets().get(i)), (BlockState)variants.get(i).m_49966_()));
            }
            ctx.m_255272_(key, (Object)new ConfiguredFeature((Feature)TIN_ORE.get(), (FeatureConfiguration)new OreConfiguration(targets, size, discardChance)));
        }

        private static void registerPlatinumOre(BootstapContext<ConfiguredFeature<?, ?>> ctx, String name, OreType type, List<Block> variants, int size, float discardChance, Supplier<Boolean> condition) {
            ResourceKey<ConfiguredFeature<?, ?>> key = Configured.create(name);
            ArrayList<OreConfiguration.TargetBlockState> targets = new ArrayList<OreConfiguration.TargetBlockState>();
            for (int i = 0; i < Math.min(type.getTargets().size(), variants.size()); ++i) {
                targets.add(OreConfiguration.m_161021_((RuleTest)((RuleTest)type.getTargets().get(i)), (BlockState)variants.get(i).m_49966_()));
            }
            ctx.m_255272_(key, (Object)new ConfiguredFeature((Feature)PLATINUM_ORE.get(), (FeatureConfiguration)new OreConfiguration(targets, size, discardChance)));
        }

        private static void registerSpelunkeryTinOre(BootstapContext<ConfiguredFeature<?, ?>> ctx, String name, OreType type, List<Block> variants, int size, float discardChance, Supplier<Boolean> condition) {
            ResourceKey<ConfiguredFeature<?, ?>> key = Configured.create(name);
            ArrayList<OreConfiguration.TargetBlockState> targets = new ArrayList<OreConfiguration.TargetBlockState>();
            for (int i = 0; i < Math.min(type.getTargets().size(), variants.size()); ++i) {
                targets.add(OreConfiguration.m_161021_((RuleTest)((RuleTest)type.getTargets().get(i)), (BlockState)variants.get(i).m_49966_()));
            }
            ctx.m_255272_(key, (Object)new ConfiguredFeature((Feature)TIN_ORE_SK.get(), (FeatureConfiguration)new OreConfiguration(targets, size, discardChance)));
        }

        private static void registerSpelunkeryPlatinumOre(BootstapContext<ConfiguredFeature<?, ?>> ctx, String name, OreType type, List<Block> variants, int size, float discardChance, Supplier<Boolean> condition) {
            ResourceKey<ConfiguredFeature<?, ?>> key = Configured.create(name);
            ArrayList<OreConfiguration.TargetBlockState> targets = new ArrayList<OreConfiguration.TargetBlockState>();
            for (int i = 0; i < Math.min(type.getTargets().size(), variants.size()); ++i) {
                targets.add(OreConfiguration.m_161021_((RuleTest)((RuleTest)type.getTargets().get(i)), (BlockState)variants.get(i).m_49966_()));
            }
            ctx.m_255272_(key, (Object)new ConfiguredFeature((Feature)PLATINUM_ORE_SK.get(), (FeatureConfiguration)new OreConfiguration(targets, size, discardChance)));
        }

        private static void registerOre(BootstapContext<ConfiguredFeature<?, ?>> ctx, String name, OreType type, List<Block> variants, int size, float discardChanceOnAir) {
            ResourceKey<ConfiguredFeature<?, ?>> key = Configured.create(name);
            ArrayList<OreConfiguration.TargetBlockState> targets = new ArrayList<OreConfiguration.TargetBlockState>();
            for (int i = 0; i < Math.min(type.getTargets().size(), variants.size()); ++i) {
                targets.add(OreConfiguration.m_161021_((RuleTest)((RuleTest)type.getTargets().get(i)), (BlockState)variants.get(i).m_49966_()));
            }
            ctx.m_255272_(key, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(targets, size, discardChanceOnAir)));
        }
    }
}

