/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.init;

import com.mojang.logging.LogUtils;
import com.teamabnormals.caverns_and_chasms.core.other.CCTiers;
import galena.oreganized.index.OItemTiers;
import java.util.List;
import java.util.function.Supplier;
import net.bexla.orevolution.compatibility.ModCompat;
import net.bexla.orevolution.content.data.Conditionals;
import net.bexla.orevolution.content.data.OrevolutionArmorTiers;
import net.bexla.orevolution.content.data.OrevolutionToolTiers;
import net.bexla.orevolution.content.data.powers.armors.ArmorCauseEffectsOnAttacked;
import net.bexla.orevolution.content.data.powers.armors.ArmorCauseEffectsOnHit;
import net.bexla.orevolution.content.data.powers.armors.ArmorGrantEffects;
import net.bexla.orevolution.content.data.powers.armors.ArmorGrantImmunityEffects;
import net.bexla.orevolution.content.data.powers.armors.ArmorMultiPower;
import net.bexla.orevolution.content.data.powers.tools.ToolAddEffectPerBlockAmount;
import net.bexla.orevolution.content.data.powers.tools.ToolAvoidDamageOnUse;
import net.bexla.orevolution.content.data.powers.tools.ToolCauseEffectOnHit;
import net.bexla.orevolution.content.data.powers.tools.ToolCauseMultipleEffectsOnHit;
import net.bexla.orevolution.content.data.powers.tools.ToolChangeBreakSpeed;
import net.bexla.orevolution.content.data.powers.tools.ToolChangeDamage;
import net.bexla.orevolution.content.data.powers.tools.ToolChangeDurability;
import net.bexla.orevolution.content.data.powers.tools.ToolIncreaseCropDrops;
import net.bexla.orevolution.content.data.powers.tools.ToolIncreaseDrops;
import net.bexla.orevolution.content.data.powers.tools.ToolIncreaseMobLoot;
import net.bexla.orevolution.content.data.powers.tools.ToolMultiBreaking;
import net.bexla.orevolution.content.data.utility.OrevolutionLists;
import net.bexla.orevolution.content.data.utility.OrevolutionTags;
import net.bexla.orevolution.content.data.utility.OrevolutionUtils;
import net.bexla.orevolution.content.types.ArmorPowerRegistry;
import net.bexla.orevolution.content.types.OrevolutionToolPower;
import net.bexla.orevolution.content.types.TierProgressRegistry;
import net.bexla.orevolution.content.types.ToolPowerRegistry;
import net.bexla.orevolution.init.RegItems;
import net.bexla.orevolution.init.RegMobEffects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import org.slf4j.Logger;

public class RegMisc {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static boolean loadOrevolutionTiers = true;

    public static void setLoadOrevolutionTiers(boolean shouldLoad) {
        loadOrevolutionTiers = shouldLoad;
    }

    public static void RegisterSortedTiers() {
        if (!loadOrevolutionTiers) {
            return;
        }
        ResourceLocation wood = new ResourceLocation("wood");
        ResourceLocation stone = new ResourceLocation("stone");
        ResourceLocation iron = new ResourceLocation("iron");
        ResourceLocation diamond = new ResourceLocation("diamond");
        ResourceLocation netherite = new ResourceLocation("netherite");
        TierProgressRegistry.registerTier((Tier)Tiers.WOOD, wood, List.of(), List.of(), OrevolutionTags.Blocks.woodTiered);
        TierProgressRegistry.registerTier((Tier)Tiers.STONE, stone, List.of(wood), List.of(iron), OrevolutionTags.Blocks.stoneTiered);
        TierProgressRegistry.registerTier((Tier)Tiers.IRON, iron, List.of(stone), List.of(diamond), OrevolutionTags.Blocks.ironTiered);
        TierProgressRegistry.registerTier((Tier)Tiers.DIAMOND, diamond, List.of(iron), List.of(netherite), OrevolutionTags.Blocks.diamondTiered);
        TierProgressRegistry.registerTier((Tier)Tiers.NETHERITE, netherite, List.of(diamond), List.of(), OrevolutionTags.Blocks.netheriteTiered);
        TierProgressRegistry.registerTier(OrevolutionToolTiers.TIN, OrevolutionUtils.modLocat("tin"), List.of(Tiers.STONE), List.of(Tiers.IRON), OrevolutionTags.Blocks.tinTiered);
        TierProgressRegistry.registerTier(OrevolutionToolTiers.PLATINUM, OrevolutionUtils.modLocat("platinum"), List.of(Tiers.IRON), List.of(Tiers.DIAMOND), OrevolutionTags.Blocks.platTiered);
        TierProgressRegistry.registerTier(OrevolutionToolTiers.AETHERSTEEL, OrevolutionUtils.modLocat("aethersteel"), List.of(Tiers.NETHERITE), List.of(), OrevolutionTags.Blocks.aethersteelTiered);
        TierProgressRegistry.registerSecondaryTier(OrevolutionToolTiers.LIVINGSTONE, OrevolutionToolTiers.TIN);
        TierProgressRegistry.registerSecondaryTier(OrevolutionToolTiers.VERDITE, OrevolutionToolTiers.PLATINUM);
        TierProgressRegistry.registerSecondaryTier((Tier)Tiers.GOLD, (Tier)Tiers.IRON);
        TierProgressRegistry.registerSecondaryTier(OrevolutionToolTiers.STEEL, OrevolutionToolTiers.PLATINUM);
        LOGGER.info("Sorted all tiers");
    }

    public static void RegisterArmorPowers() {
        ArmorPowerRegistry.register((ArmorMaterial)ArmorMaterials.CHAIN, new ArmorGrantEffects("armor_wearer_grants", Conditionals.always(), 20, 1, OrevolutionLists.GOLD_ARMOR_EFFECTS));
        ArmorPowerRegistry.register((ArmorMaterial)ArmorMaterials.GOLD, new ArmorGrantEffects("armor_wearer_grants", Conditionals.always(), 20, 1, OrevolutionLists.GOLD_ARMOR_EFFECTS));
        ArmorPowerRegistry.register(OrevolutionArmorTiers.PLATINUM, new ArmorCauseEffectsOnAttacked("", "armor_wearer_on_attacked_wearer", Conditionals.always(), 100, 1, () -> MobEffects.f_19600_, null));
        ArmorPowerRegistry.register((ArmorMaterial)ArmorMaterials.NETHERITE, new ArmorCauseEffectsOnHit("netherite_armor", "", Conditionals.isCurrentHPPercentage(0.5f), 20, 0, () -> MobEffects.f_19615_, null));
        ArmorPowerRegistry.register(OrevolutionArmorTiers.REINFORCED_NETHERITE, new ArmorMultiPower(OrevolutionLists.REINFORCED_ARMOR_POWERS));
        ArmorPowerRegistry.register(OrevolutionArmorTiers.AETHERSTEEL, new ArmorMultiPower(OrevolutionLists.AETHERSTEEL_ARMOR_POWERS));
        ArmorPowerRegistry.register(OrevolutionArmorTiers.LIVINGSTONE, new ArmorGrantImmunityEffects("armor_immunity_daylight", Conditionals.isReceivingDayLight(), () -> MobEffects.f_19612_));
        ArmorPowerRegistry.register(OrevolutionArmorTiers.VERDITE, new ArmorMultiPower(OrevolutionLists.VERDITE_ARMOR_POWERS));
        ArmorPowerRegistry.registerItem(RegItems.BRONZE_CROWN, new ArmorGrantImmunityEffects("armor_immunity", Conditionals.always(), () -> MobEffects.f_19612_));
        ArmorPowerRegistry.registerItem(RegItems.BRONZE_CROWN_REDSTONE, new ArmorGrantEffects("armor_grants", Conditionals.always(), 20, 0, OrevolutionLists.BRONZE_REDSTONE_EFFECTS));
        ArmorPowerRegistry.registerItem(RegItems.BRONZE_CROWN_DIAMOND, new ArmorCauseEffectsOnAttacked("", "armor_wearer_on_attacked_wearer", Conditionals.always(), 140, 0, null, () -> MobEffects.f_19605_));
        ArmorPowerRegistry.registerItem(RegItems.BRONZE_CROWN_EMERALD, new ArmorGrantEffects("armor_immunity", Conditionals.always(), 20, 0, () -> MobEffects.f_19595_));
        ArmorPowerRegistry.registerItem(RegItems.BRONZE_CROWN_LAPIS, new ArmorGrantEffects("armor_grants", Conditionals.always(), 30, 0, () -> MobEffects.f_19611_));
        LOGGER.debug("Registered all armor powers");
    }

    public static void RegisterToolsPowers() {
        ToolPowerRegistry.registerTier(OrevolutionToolTiers.TIN, new ToolIncreaseDrops("duplication", Conditionals.always(), 1, 0.3, 1.0), new ToolCauseEffectOnHit("on_hit_effect_chance", "", Conditionals.byChance(0.3), 120, 0, () -> MobEffects.f_19614_, null));
        ToolPowerRegistry.registerTier((Tier)Tiers.IRON, new ToolChangeBreakSpeed("iron_tool_tooltip", OrevolutionUtils.Conditions.IronConditionals, 3.0f), new ToolIncreaseMobLoot("increase_loot", Conditionals.always(), 1.5f, 0.4));
        ToolPowerRegistry.registerTier((Tier)Tiers.GOLD, new ToolChangeDurability("gold_tool_tooltip", Conditionals.toolHasAnyEnchantment(), 160), new ToolCauseEffectOnHit("on_hit_effect", "", Conditionals.always(), 120, 0, () -> MobEffects.f_19613_, null));
        ToolPowerRegistry.registerTier(OrevolutionToolTiers.STEEL, new ToolMultiBreaking("multi_break", Conditionals.always()), new ToolCauseEffectOnHit("on_hit_effect_chance", "", Conditionals.always(), 180, 0, (Supplier<MobEffect>)RegMobEffects.CRUSHED, null));
        ToolPowerRegistry.registerTier(OrevolutionToolTiers.PLATINUM, new ToolAvoidDamageOnUse("avoid_damage", Conditionals.byChance(0.25)), new ToolCauseMultipleEffectsOnHit("undead_on_hit", "", Conditionals.isTargetMobType(MobType.f_21641_), 160, 0, OrevolutionLists.PLATINUM_TOOL_EFFECTS, null));
        ToolPowerRegistry.registerTier(OrevolutionToolTiers.AETHERSTEEL, new ToolAvoidDamageOnUse("avoid_damage", Conditionals.byChance(0.05)), new ToolCauseEffectOnHit("attacker_on_hit_effect", "", Conditionals.byChance(0.7), 80, 0, () -> MobEffects.f_19605_, null));
        ToolPowerRegistry.registerTier(OrevolutionToolTiers.LIVINGSTONE, new ToolIncreaseCropDrops("duplication_crops", Conditionals.always(), 1, 0.4), new ToolCauseEffectOnHit("", "on_hit_effect_chance", Conditionals.byChance(0.1), 1, 0, null, () -> MobEffects.f_19618_));
        ToolPowerRegistry.registerTier(OrevolutionToolTiers.VERDITE, new ToolIncreaseCropDrops("duplication_crops", Conditionals.always(), 2, 0.6), new ToolCauseEffectOnHit("", "on_hit_effect_chance", Conditionals.byChance(0.2), 2, 0, null, () -> MobEffects.f_19618_));
        if (ModCompat.isModLoaded(ModCompat.OREGANIZED)) {
            ToolPowerRegistry.registerTier((Tier)OItemTiers.ELECTRUM, new ToolAddEffectPerBlockAmount("grant_on_mine", Conditionals.always(), () -> MobEffects.f_19598_, 6, 120, 3), new OrevolutionToolPower("electrum", Conditionals.always()));
        }
        if (ModCompat.isModLoaded(ModCompat.CAC)) {
            ToolPowerRegistry.registerTier(CCTiers.CCItemTiers.SILVER, new ToolAvoidDamageOnUse("avoid_damage", Conditionals.byChance(0.25)), new ToolCauseMultipleEffectsOnHit("undead_on_hit", "", Conditionals.isTargetMobType(MobType.f_21641_), 160, 0, OrevolutionLists.PLATINUM_TOOL_EFFECTS, null));
            ToolPowerRegistry.registerTier(CCTiers.CCItemTiers.NECROMIUM, new ToolChangeDamage("copper_duplication", Conditionals.always(), 2.0f), new ToolCauseEffectOnHit("on_hit_effect_chance", "", Conditionals.isTargetHPPercentage(0.25f), 140, 0, null, () -> MobEffects.f_19605_));
        }
        LOGGER.debug("Registered all tool powers");
    }

    public static void RegisterAll() {
        RegMisc.RegisterSortedTiers();
        RegMisc.RegisterArmorPowers();
        RegMisc.RegisterToolsPowers();
    }
}

