/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.mixins;

import net.bexla.orevolution.OrevolutionConfig;
import net.bexla.orevolution.content.types.ToolPowerRegistry;
import net.bexla.orevolution.content.types.interfaces.ToolPower;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DiggerItem.class})
public class DiggerItemMixin {
    @Inject(method={"getAttackDamage"}, at={@At(value="RETURN")}, cancellable=true)
    private void orevolution$injectAttackDamage(CallbackInfoReturnable<Float> cir) {
        DiggerItem item = (DiggerItem)this;
        ItemStack stack = item.m_7968_();
        Item item2 = stack.m_41720_();
        if (!(item2 instanceof TieredItem)) {
            return;
        }
        TieredItem tiered = (TieredItem)item2;
        float dmg = ((Float)cir.getReturnValue()).floatValue();
        if (tiered instanceof SwordItem && ((Boolean)OrevolutionConfig.COMMON.weaponsPowers.get()).booleanValue()) {
            ToolPower power = ToolPowerRegistry.getSwordPowerForTier(tiered.m_43314_());
            dmg = power.setAttackDamage(stack, ((Float)cir.getReturnValue()).floatValue());
        } else if (tiered instanceof DiggerItem && ((Boolean)OrevolutionConfig.COMMON.toolsPowers.get()).booleanValue()) {
            ToolPower power = ToolPowerRegistry.getToolPowerForTier(tiered.m_43314_());
            dmg = power.setAttackDamage(stack, ((Float)cir.getReturnValue()).floatValue());
        }
        cir.setReturnValue((Object)Float.valueOf(dmg));
    }

    @Inject(method={"mineBlock"}, at={@At(value="HEAD")})
    private void orevolution$injectPowerMining(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity, CallbackInfoReturnable<Boolean> cir) {
        Item item = stack.m_41720_();
        if (item instanceof DiggerItem) {
            DiggerItem tieredItem = (DiggerItem)item;
            if (!((Boolean)OrevolutionConfig.COMMON.toolsPowers.get()).booleanValue()) {
                return;
            }
            ToolPower power = ToolPowerRegistry.getToolPowerForTier(tieredItem.m_43314_());
            if (power == null) {
                return;
            }
            power.onMineBlock(stack, level, pos, entity, state);
            if (power.onUseOverride(stack, level, entity) && cir.isCancellable()) {
                cir.setReturnValue((Object)true);
                cir.cancel();
            }
        }
    }

    @Inject(method={"hurtEnemy"}, at={@At(value="HEAD")})
    private void orevolution$injectPowerAttackEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker, CallbackInfoReturnable<Boolean> cir) {
        Item item = stack.m_41720_();
        if (item instanceof DiggerItem) {
            DiggerItem tieredItem = (DiggerItem)item;
            if (!((Boolean)OrevolutionConfig.COMMON.toolsPowers.get()).booleanValue()) {
                return;
            }
            ToolPower power = ToolPowerRegistry.getToolPowerForTier(tieredItem.m_43314_());
            if (power == null) {
                return;
            }
            power.onHitEntity(stack, target, attacker);
            if (power.onUseOverride(stack, attacker.m_9236_(), attacker) && cir.isCancellable()) {
                cir.setReturnValue((Object)true);
                cir.cancel();
            }
        }
    }
}

