/*
 * Decompiled with CFR 0.152.
 */
package com.sopze.mc.ironrust.block;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.serialization.Codec;
import com.sopze.mc.ironrust.block.ModBlocks;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3621;
import net.minecraft.class_5547;
import net.minecraft.class_5819;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public interface I_Rustable
extends class_5547<RustLevel> {
    public static final Supplier<BiMap<class_2248, class_2248>> RUST_LEVEL_INCREASES = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)class_2246.field_10085, (Object)ModBlocks.EXPOSED_IRON).put((Object)ModBlocks.EXPOSED_IRON, (Object)ModBlocks.WEATHERED_IRON).put((Object)ModBlocks.WEATHERED_IRON, (Object)ModBlocks.OXIDIZED_IRON).put((Object)class_2246.field_9973, (Object)ModBlocks.EXPOSED_IRON_DOOR).put((Object)ModBlocks.EXPOSED_IRON_DOOR, (Object)ModBlocks.WEATHERED_IRON_DOOR).put((Object)ModBlocks.WEATHERED_IRON_DOOR, (Object)ModBlocks.OXIDIZED_IRON_DOOR).put((Object)class_2246.field_10453, (Object)ModBlocks.EXPOSED_IRON_TRAPDOOR).put((Object)ModBlocks.EXPOSED_IRON_TRAPDOOR, (Object)ModBlocks.WEATHERED_IRON_TRAPDOOR).put((Object)ModBlocks.WEATHERED_IRON_TRAPDOOR, (Object)ModBlocks.OXIDIZED_IRON_TRAPDOOR).put((Object)class_2246.field_10576, (Object)ModBlocks.EXPOSED_IRON_BARS).put((Object)ModBlocks.EXPOSED_IRON_BARS, (Object)ModBlocks.WEATHERED_IRON_BARS).put((Object)ModBlocks.WEATHERED_IRON_BARS, (Object)ModBlocks.OXIDIZED_IRON_BARS).put((Object)ModBlocks.IRON_GRATE, (Object)ModBlocks.EXPOSED_IRON_GRATE).put((Object)ModBlocks.EXPOSED_IRON_GRATE, (Object)ModBlocks.WEATHERED_IRON_GRATE).put((Object)ModBlocks.WEATHERED_IRON_GRATE, (Object)ModBlocks.OXIDIZED_IRON_GRATE).put((Object)class_2246.field_23985, (Object)ModBlocks.EXPOSED_IRON_CHAIN).put((Object)ModBlocks.EXPOSED_IRON_CHAIN, (Object)ModBlocks.WEATHERED_IRON_CHAIN).put((Object)ModBlocks.WEATHERED_IRON_CHAIN, (Object)ModBlocks.OXIDIZED_IRON_CHAIN).build());
    public static final Supplier<BiMap<class_2248, class_2248>> RUST_LEVEL_DECREASES = Suppliers.memoize(() -> RUST_LEVEL_INCREASES.get().inverse());
    public static final float[] CHANCE_MULTIPLIER_BY_DEGRADATION = new float[]{0.85f, 1.0f, 1.02f, 1.06f};
    public static final float[] CHANCE_ADDER_BY_WATER_DISTANCE = new float[]{0.17f, 0.09f, 0.04f, 0.0f};
    public static final float[] CHANCE_ADDER_BY_WATER_AMOUNT = new float[]{0.0f, 0.015f, 0.04f, 0.075f, 0.13f, 0.19f, 0.265f, 0.325f, 0.365f, 0.385f, 0.4f};

    default public void method_54764(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        float[] baseChances = this.getDegradationChanceMultiplierWorld(state, world, pos);
        float passChance = 0.04988889f + baseChances[0] * 0.013774f;
        if (random.method_43057() < passChance) {
            this.tryDegrade(state, world, pos, random, baseChances[1]).ifPresent(degraded -> world.method_8501(pos, degraded));
        }
    }

    default public Optional<class_2680> tryDegrade(class_2680 state, class_3218 world, class_2338 pos, class_5819 random, float waterFactor) {
        int levelCurrent = ((RustLevel)this.method_33622()).ordinal();
        int surroundingEquals = 0;
        int surroundingHighers = 0;
        for (class_2338 blockPos : class_2338.method_25996((class_2338)pos, (int)4, (int)4, (int)4)) {
            class_2248 blockTest;
            if (blockPos.equals((Object)pos) || blockPos.method_19455((class_2382)pos) > 4 || !((blockTest = world.method_8320(blockPos).method_26204()) instanceof class_5547)) continue;
            class_5547 degradable = (class_5547)blockTest;
            Enum degradationLevelTest = degradable.method_33622();
            if (((Object)((Object)((RustLevel)this.method_33622()))).getClass() != degradationLevelTest.getClass()) continue;
            int levelCurrentTest = degradationLevelTest.ordinal();
            if (levelCurrentTest == levelCurrent) {
                ++surroundingEquals;
                continue;
            }
            if (levelCurrentTest <= levelCurrent) continue;
            ++surroundingHighers;
        }
        float ratio = (float)(surroundingHighers + 1) / (float)(surroundingHighers + surroundingEquals + 1) + waterFactor;
        float finalFactor = ratio * ratio * (this.method_33620() + waterFactor);
        return random.method_43057() < finalFactor ? this.method_31639(state) : Optional.empty();
    }

    public static Optional<class_2248> getDecreasedRustBlock(class_2248 block) {
        return Optional.ofNullable((class_2248)RUST_LEVEL_DECREASES.get().get((Object)block));
    }

    public static class_2248 getUnaffectedRustBlock(class_2248 block) {
        class_2248 block2 = block;
        class_2248 block3 = (class_2248)RUST_LEVEL_DECREASES.get().get((Object)block);
        while (block3 != null) {
            block2 = block3;
            block3 = (class_2248)RUST_LEVEL_DECREASES.get().get((Object)block3);
        }
        return block2;
    }

    public static Optional<class_2680> getDecreasedRustState(class_2680 state) {
        return I_Rustable.getDecreasedRustBlock(state.method_26204()).map(block -> block.method_34725(state));
    }

    public static Optional<class_2248> getIncreasedRustBlock(class_2248 block) {
        return Optional.ofNullable((class_2248)RUST_LEVEL_INCREASES.get().get((Object)block));
    }

    public static class_2680 getUnaffectedRustState(class_2680 state) {
        return I_Rustable.getUnaffectedRustBlock(state.method_26204()).method_34725(state);
    }

    default public Optional<class_2680> method_31639(class_2680 state) {
        return I_Rustable.getIncreasedRustBlock(state.method_26204()).map(block -> block.method_34725(state));
    }

    default public float method_33620() {
        return CHANCE_MULTIPLIER_BY_DEGRADATION[((RustLevel)this.method_33622()).ordinal()];
    }

    default public float[] getDegradationChanceMultiplierWorld(class_2680 state, class_3218 world, class_2338 pos) {
        int areaX = 6;
        int areaY = 3;
        int waterNeighborCountMax = CHANCE_ADDER_BY_WATER_AMOUNT.length - 1;
        float waterNeighborFactor = 0.0f;
        int waterNeighborsCount = 0;
        int waterClosestDistance = 8;
        class_2338 lookupPos = pos.method_10074();
        for (class_2338 blockPos : class_2338.method_25996((class_2338)lookupPos, (int)6, (int)3, (int)6)) {
            class_3610 checkFluidState;
            class_2680 checkBlockState;
            int distance;
            if (blockPos.equals((Object)pos) || (distance = blockPos.method_19455((class_2382)lookupPos)) > 6 || !((checkBlockState = world.method_8320(blockPos)).method_26204() instanceof class_2404) || !((checkFluidState = checkBlockState.method_26227()).method_15772() instanceof class_3621)) continue;
            if (distance < waterClosestDistance) {
                waterClosestDistance = distance;
            }
            waterNeighborFactor += 0.125f * (float)checkFluidState.method_15761();
            if (++waterNeighborsCount != waterNeighborCountMax) continue;
            break;
        }
        int waterFactor = Math.clamp((long)(waterClosestDistance / 2 - 1), 0, 3);
        float amountFactor = 1.0f + CHANCE_ADDER_BY_WATER_AMOUNT[Math.clamp((long)((int)Math.floor(waterNeighborFactor)), 0, waterNeighborCountMax)];
        return new float[]{(float)waterFactor * amountFactor, CHANCE_ADDER_BY_WATER_DISTANCE[waterFactor] * amountFactor};
    }

    public static enum RustLevel implements class_3542
    {
        UNAFFECTED("unaffected"),
        EXPOSED("exposed"),
        WEATHERED("weathered"),
        OXIDIZED("oxidized");

        public static final IntFunction<RustLevel> indexMapper;
        public static final Codec<RustLevel> CODEC;
        public static final class_9139<ByteBuf, RustLevel> PACKET_CODEC;
        private final String id;

        private RustLevel(String id) {
            this.id = id;
        }

        public String method_15434() {
            return this.id;
        }

        public RustLevel getIncreased() {
            return indexMapper.apply(this.ordinal() + 1);
        }

        public RustLevel getDecreased() {
            return indexMapper.apply(this.ordinal() - 1);
        }

        static {
            indexMapper = class_7995.method_47914(Enum::ordinal, (Object[])RustLevel.values(), (class_7995.class_7996)class_7995.class_7996.field_41666);
            CODEC = class_3542.method_28140(RustLevel::values);
            PACKET_CODEC = class_9135.method_56375(indexMapper, Enum::ordinal);
        }
    }
}

