/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.mixin;

import java.util.Optional;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.WeatheringCopperFullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.seface.somemoreblocks.registries.SMBRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WeatheringCopperFullBlock.class})
public abstract class WeatheringCopperFullBlockMixin
implements WeatheringCopper {
    public Optional<BlockState> getNext(BlockState state) {
        Block block = state.getBlock();
        Optional<Block> nextBlock = SMBRegistries.WEATHERING_COPPER_BLOCKS.getNext(block);
        if (nextBlock.isPresent()) {
            return nextBlock.map(_block -> _block.withPropertiesOf(state));
        }
        return Optional.of(((Block)WeatheringCopper.getNext((Block)block).get()).withPropertiesOf(state));
    }

    @Inject(method={"isRandomlyTicking"}, at={@At(value="HEAD")}, cancellable=true)
    public void isRandomlyTickingMixin(BlockState state, CallbackInfoReturnable<Boolean> cir) {
        Optional<Block> nextBlock = SMBRegistries.WEATHERING_COPPER_BLOCKS.getNext(state.getBlock());
        if (nextBlock.isPresent()) {
            cir.setReturnValue((Object)true);
        }
    }
}

