/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.seface.somemoreblocks.block.DoubleMushroomColonyBlock;
import net.seface.somemoreblocks.registries.SMBBlocks;
import net.seface.somemoreblocks.tags.SMBBlockTags;

public class TinyCactusBlock
extends TallGrassBlock {
    public TinyCactusBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockBelow = level.getBlockState(pos.below());
        return blockBelow.is(SMBBlockTags.CACTUS_PLANTS_PLACEABLE) && !level.getBlockState(pos.above()).liquid();
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier, boolean b) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        entity.hurt(level.damageSources().cactus(), 1.0f);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return ((Block)SMBBlocks.TALL_CACTUS.get()).defaultBlockState().canSurvive(level, pos) && level.isEmptyBlock(pos.above());
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        DoubleMushroomColonyBlock.placeAt((LevelAccessor)level, (BlockState)((Block)SMBBlocks.TALL_CACTUS.get()).defaultBlockState(), (BlockPos)pos, (int)2);
    }
}

