/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.platform.registry;

import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.seface.somemoreblocks.SomeMoreBlocks;
import net.seface.somemoreblocks.platform.registry.NeoForgeRegistryObject;
import net.seface.somemoreblocks.platform.registry.PlatformRegistry;
import net.seface.somemoreblocks.platform.registry.PlatformRegistryObject;

public class NeoForgePlatformRegistry
implements PlatformRegistry {
    private static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"somemoreblocks");
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"somemoreblocks");
    private static final DeferredRegister.DataComponents DATA_COMPONENT_TYPES = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"somemoreblocks");
    private static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((ResourceKey)Registries.FEATURE, (String)"somemoreblocks");
    private static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"somemoreblocks");

    @Override
    public PlatformRegistryObject<Block> registerBlock(String path, Supplier<Block> supplier, boolean registerBlockItem) {
        ResourceLocation identifier = SomeMoreBlocks.id(path);
        DeferredBlock instance = BLOCKS.register(path, supplier);
        if (registerBlockItem) {
            this.registerItem(path, () -> new BlockItem((Block)instance.get(), new Item.Properties().useBlockDescriptionPrefix().setId(SomeMoreBlocks.key(Registries.ITEM, path))));
        }
        return new NeoForgeRegistryObject(identifier, instance);
    }

    @Override
    public PlatformRegistryObject<Item> registerItem(String path, Supplier<Item> supplier) {
        ResourceLocation identifier = SomeMoreBlocks.id(path);
        DeferredItem instance = ITEMS.register(path, supplier);
        return new NeoForgeRegistryObject(identifier, instance);
    }

    @Override
    public <T> PlatformRegistryObject<DataComponentType<T>> registerDataComponent(String path, UnaryOperator<DataComponentType.Builder<T>> builder) {
        ResourceLocation identifier = SomeMoreBlocks.id(path);
        DeferredHolder instance = DATA_COMPONENT_TYPES.register(path, () -> ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build());
        return new NeoForgeRegistryObject(identifier, instance);
    }

    @Override
    public <F extends Feature<? extends FeatureConfiguration>> PlatformRegistryObject<F> registerFeature(String path, Supplier<F> supplier) {
        ResourceLocation identifier = SomeMoreBlocks.id(path);
        DeferredHolder instance = FEATURES.register(path, supplier);
        return new NeoForgeRegistryObject(identifier, instance);
    }

    @Override
    public PlatformRegistryObject<CreativeModeTab> registerCreativeModeTab(String path, CreativeModeTab.Row row, int i, UnaryOperator<CreativeModeTab.Builder> builder) {
        ResourceLocation identifier = SomeMoreBlocks.id(path);
        DeferredHolder instance = CREATIVE_MODE_TABS.register(path, () -> ((CreativeModeTab.Builder)builder.apply(CreativeModeTab.builder((CreativeModeTab.Row)row, (int)i))).build());
        return new NeoForgeRegistryObject(identifier, instance);
    }

    @Override
    public GameRules.Key<GameRules.BooleanValue> registerBooleanGameRule(String id, GameRules.Category category, boolean defaultValue) {
        return GameRules.register((String)id, (GameRules.Category)category, (GameRules.Type)GameRules.BooleanValue.create((boolean)defaultValue));
    }

    @Override
    public void setBlockRenderType(Block block, ChunkSectionLayer renderType) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, (ChunkSectionLayer)renderType);
    }

    public static void init(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        DATA_COMPONENT_TYPES.register(eventBus);
        FEATURES.register(eventBus);
        CREATIVE_MODE_TABS.register(eventBus);
    }
}

