/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.mixin;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LeafLitterBlock;
import net.minecraft.world.level.block.SegmentableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.seface.somemoreblocks.registries.SMBDataComponentTypes;
import net.seface.somemoreblocks.registries.SMBGameRules;
import net.seface.somemoreblocks.registries.SMBItems;
import net.seface.somemoreblocks.registries.SMBRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={LeafLitterBlock.class})
public abstract class LeafLitterBlockMixin
extends VegetationBlock
implements SegmentableBlock,
BucketPickup {
    protected LeafLitterBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean bool) {
        return state.getBlock() == Blocks.LEAF_LITTER ? Items.LEAF_LITTER.getDefaultInstance() : super.getCloneItemStack(level, pos, state, bool);
    }

    public ItemStack pickupBlock(@Nullable LivingEntity entity, LevelAccessor level, BlockPos pos, BlockState state) {
        ItemStack stack = SMBRegistries.LEAVES_BUCKET.getNext((Block)this).orElse((Item)SMBItems.LEAVES_BUCKET.get()).getDefaultInstance();
        if ((Integer)state.getValue((Property)LeafLitterBlock.AMOUNT) > 1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)LeafLitterBlock.AMOUNT, (Comparable)Integer.valueOf((Integer)state.getValue((Property)LeafLitterBlock.AMOUNT) - 1)), 11);
        } else {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        }
        if (!level.isClientSide()) {
            level.levelEvent(2001, pos, Block.getId((BlockState)state));
        }
        stack.set((DataComponentType)SMBDataComponentTypes.BUCKET_VOLUME.get(), (Object)1);
        return stack;
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return state.getBlock() != Blocks.LEAF_LITTER;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.getGameRules().getBoolean(SMBGameRules.RULE_DRY_LEAF_LITTER) && random.nextInt(25) == 0) {
            level.setBlock(pos, Blocks.LEAF_LITTER.withPropertiesOf(state), 3);
        }
    }

    @NotNull
    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundType.LEAF_LITTER.getBreakSound());
    }
}

