/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.datagen.providers.assets.providers;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10405;
import net.minecraft.class_10410;
import net.minecraft.class_10411;
import net.minecraft.class_10439;
import net.minecraft.class_10448;
import net.minecraft.class_10804;
import net.minecraft.class_10821;
import net.minecraft.class_1800;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4941;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_6012;
import net.minecraft.class_7923;
import net.minecraft.class_807;
import net.minecraft.class_813;
import net.seface.somemoreblocks.block.RotatedCarvedPaleOakBlock;
import net.seface.somemoreblocks.item.properties.numeric.MoonPhaseProperty;

@Environment(value=EnvType.CLIENT)
public class CarvedWoodBlockProvider {
    private final class_2248 block;
    private final class_4944 mainTextureMap;
    private final BiConsumer<class_2960, class_10411> modelOutput;
    private final class_10405 itemModelOutput;
    private final Consumer<class_4917> blockStateOutput;

    public CarvedWoodBlockProvider(class_2248 block, BiConsumer<class_2960, class_10411> modelOutput, class_10405 itemModelOutput, Consumer<class_4917> blockStateOutput) {
        this.block = block;
        this.mainTextureMap = class_4944.method_25897((class_2248)block);
        this.modelOutput = modelOutput;
        this.itemModelOutput = itemModelOutput;
        this.blockStateOutput = blockStateOutput;
    }

    public CarvedWoodBlockProvider log(class_2248 block, class_2248 topBottomBlock) {
        class_4944 textureMapping = this.mainTextureMap.method_25879(class_4945.field_23013, class_4941.method_25842((class_2248)topBottomBlock).method_48331("_top"));
        class_2960 verticalModel = class_4943.field_22974.method_25846(block, textureMapping, this.modelOutput);
        this.blockStateOutput.accept(CarvedWoodBlockProvider.createAxisAlignedPillarBlock(block, class_4910.method_67835((class_2960)verticalModel)));
        return this;
    }

    public CarvedWoodBlockProvider logByMoonPhase(class_2248 block, class_2248 topBottomBlock) {
        class_10448.class_10449[] overrides = new class_10448.class_10449[8];
        for (int i = 0; i <= 7; ++i) {
            String suffix = "_" + i;
            class_4944 textureMapping = this.mainTextureMap.method_25879(class_4945.field_23018, this.mainTextureMap.method_25867(class_4945.field_23018).method_48331(suffix)).method_25879(class_4945.field_23013, class_4941.method_25842((class_2248)topBottomBlock).method_48331("_top"));
            class_2960 verticalModel = class_4943.field_22974.method_25847(block, suffix, textureMapping, this.modelOutput);
            class_2960 horizontalModel = class_4943.field_22975.method_25847(block, suffix, textureMapping, this.modelOutput);
            overrides[i] = class_10410.method_65486((class_10439.class_10441)class_10410.method_65481((class_2960)verticalModel), (float)i);
        }
        class_2960 verticalModel = class_7923.field_41175.method_10221((Object)block).method_45138("block/");
        class_2960 horizontalModel = class_7923.field_41175.method_10221((Object)block).method_45138("block/").method_48331("_horizontal");
        class_10439.class_10441 itemModel = class_10410.method_65491((class_1800)new MoonPhaseProperty(), (class_10439.class_10441)overrides[0].comp_3394(), (class_10448.class_10449[])overrides);
        this.itemModelOutput.method_65460(block.method_8389(), itemModel);
        this.blockStateOutput.accept(CarvedWoodBlockProvider.createRotatedPillarWithHorizontalAndMoonPhaseVariant(block, verticalModel, horizontalModel));
        return this;
    }

    public CarvedWoodBlockProvider wood(class_2248 block) {
        class_4944 textureMapping = this.mainTextureMap.method_25879(class_4945.field_23013, this.mainTextureMap.method_25867(class_4945.field_23018));
        class_2960 model = class_4943.field_22974.method_25852(class_4941.method_25842((class_2248)block), textureMapping, this.modelOutput);
        this.blockStateOutput.accept(CarvedWoodBlockProvider.createAxisAlignedPillarBlock(block, class_4910.method_67835((class_2960)model)));
        return this;
    }

    public CarvedWoodBlockProvider woodByMoonPhase(class_2248 block) {
        class_10448.class_10449[] overrides = new class_10448.class_10449[8];
        for (int i = 0; i <= 7; ++i) {
            String suffix = "_" + i;
            class_2960 textureLocation = this.mainTextureMap.method_25867(class_4945.field_23018).method_48331(suffix);
            class_4944 textureMapping = this.mainTextureMap.method_25879(class_4945.field_23018, textureLocation).method_25879(class_4945.field_23013, textureLocation);
            class_2960 model = class_4943.field_22974.method_25847(block, suffix, textureMapping, this.modelOutput);
            overrides[i] = class_10410.method_65486((class_10439.class_10441)class_10410.method_65481((class_2960)model), (float)i);
        }
        class_2960 model = class_4941.method_25842((class_2248)block);
        class_10439.class_10441 itemModel = class_10410.method_65491((class_1800)new MoonPhaseProperty(), (class_10439.class_10441)overrides[0].comp_3394(), (class_10448.class_10449[])overrides);
        this.itemModelOutput.method_65460(block.method_8389(), itemModel);
        this.blockStateOutput.accept(CarvedWoodBlockProvider.createRotatedPillarWithHorizontalAndMoonPhaseVariant(block, model, model));
        return this;
    }

    public static class_4917 createRotatedPillarWithHorizontalAndMoonPhaseVariant(class_2248 block, class_2960 vertical, class_2960 horizontal) {
        class_4926.class_4928 c2 = class_4926.method_67865((class_2769)class_2741.field_12496, (class_2769)RotatedCarvedPaleOakBlock.MOON_PHASE);
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            for (int i = 0; i <= 7; ++i) {
                String suffix = "_" + i;
                class_807 variant = new class_807(class_6012.method_66214((Object)new class_813(vertical))).method_67929(class_10804.field_56938.withValue((Object)(axis == class_2350.class_2351.field_11052 ? vertical.method_48331(suffix) : horizontal.method_45134(path -> {
                    if (path.endsWith("_horizontal")) {
                        return path.replace("_horizontal", suffix + "_horizontal");
                    }
                    return path + suffix;
                }))));
                if (axis == class_2350.class_2351.field_11048 || axis == class_2350.class_2351.field_11051) {
                    variant.method_67929(class_10804.field_56936.withValue((Object)class_10821.field_57030));
                    if (axis == class_2350.class_2351.field_11048) {
                        variant.method_67929(class_10804.field_56937.withValue((Object)class_10821.field_57030));
                    }
                }
                c2.method_25798((Comparable)axis, (Comparable)Integer.valueOf(i), (Object)variant);
            }
        }
        return class_4925.method_67852((class_2248)block).method_67859((class_4926)c2);
    }

    public static class_4917 createAxisAlignedPillarBlock(class_2248 block, class_807 multiVariant) {
        return class_4925.method_67853((class_2248)block, (class_807)multiVariant).method_25775(class_4910.method_25649());
    }
}

