/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.item;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeafLitterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.seface.somemoreblocks.registries.SMBDataComponentTypes;
import org.jetbrains.annotations.NotNull;

public class LeavesBucketItem
extends SolidBucketItem {
    public static final int MAX_VOLUME = 32;
    public static final int MIN_VOLUME = 1;
    private static final int BAR_COLOR = 8418303;
    private final BlockState leafLitter;

    public LeavesBucketItem(Block block, SoundEvent placeSound, Item.Properties properties) {
        super(block, placeSound, properties);
        this.leafLitter = block.defaultBlockState();
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Player player = ctx.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        InteractionHand hand = ctx.getHand();
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState state = level.getBlockState(pos);
        ItemStack stack = ctx.getItemInHand();
        int bucketVolume = (Integer)stack.getComponents().getOrDefault((DataComponentType)SMBDataComponentTypes.BUCKET_VOLUME.get(), (Object)1);
        if (state.getBlock().equals(this.getBlock()) && player.isCrouching()) {
            LeavesBucketItem.collectLeafLitterSegment(player, stack, level, pos);
            LeavesBucketItem.increaseBucketVolume(player, hand, stack);
            return InteractionResult.SUCCESS;
        }
        if (bucketVolume > 0) {
            BlockPlaceContext placeContext = new BlockPlaceContext(ctx);
            BlockPos relativePos = placeContext.getClickedPos();
            BlockState relativeBlock = level.getBlockState(relativePos);
            if (!relativeBlock.canBeReplaced()) {
                return InteractionResult.FAIL;
            }
            if (relativeBlock.is(this.leafLitter.getBlock())) {
                if ((Integer)relativeBlock.getValue((Property)LeafLitterBlock.AMOUNT) == 4) {
                    return InteractionResult.FAIL;
                }
                this.placeLeafLitterSegment(ctx, false);
                LeavesBucketItem.decreaseBucketVolume(player, ctx.getHand(), stack);
                return InteractionResult.SUCCESS;
            }
            if (!this.canPlace(placeContext, this.leafLitter)) {
                return InteractionResult.FAIL;
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, stack);
            }
            this.placeLeafLitterSegment(ctx, true);
            if (player.isCreative()) {
                return InteractionResult.SUCCESS;
            }
            LeavesBucketItem.decreaseBucketVolume(player, ctx.getHand(), stack);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean isBarVisible(ItemStack stack) {
        return (Integer)stack.getComponents().getOrDefault((DataComponentType)SMBDataComponentTypes.BUCKET_VOLUME.get(), (Object)1) < 32;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.min(13 * (Integer)stack.getComponents().getOrDefault((DataComponentType)SMBDataComponentTypes.BUCKET_VOLUME.get(), (Object)1) / 32, 32);
    }

    public int getBarColor(ItemStack stack) {
        return 8418303;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, ctx, display, tooltip, tooltipFlag);
        int bucketVolume = (Integer)stack.getComponents().getOrDefault((DataComponentType)SMBDataComponentTypes.BUCKET_VOLUME.get(), (Object)1);
        tooltip.accept((Component)Component.translatable((String)"item.somemoreblocks.leaves_bucket.volume_description", (Object[])new Object[]{bucketVolume, 32}).withStyle(ChatFormatting.GRAY));
    }

    private static void increaseBucketVolume(Player player, InteractionHand hand, ItemStack stack) {
        int currentVolume = (Integer)stack.getComponents().getOrDefault((DataComponentType)SMBDataComponentTypes.BUCKET_VOLUME.get(), (Object)1);
        if (currentVolume < 32) {
            stack.set((DataComponentType)SMBDataComponentTypes.BUCKET_VOLUME.get(), (Object)(currentVolume + 1));
        }
    }

    private static void decreaseBucketVolume(Player player, InteractionHand hand, ItemStack stack) {
        int currentVolume = (Integer)stack.getComponents().getOrDefault((DataComponentType)SMBDataComponentTypes.BUCKET_VOLUME.get(), (Object)1);
        if (!player.isCreative()) {
            if (currentVolume > 1) {
                stack.set((DataComponentType)SMBDataComponentTypes.BUCKET_VOLUME.get(), (Object)(currentVolume - 1));
            } else {
                player.setItemInHand(hand, BucketItem.getEmptySuccessItem((ItemStack)stack, (Player)player));
            }
        }
    }

    public static void collectLeafLitterSegment(Player player, ItemStack stack, Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        int bucketVolume = (Integer)stack.getComponents().getOrDefault((DataComponentType)SMBDataComponentTypes.BUCKET_VOLUME.get(), (Object)1);
        if (bucketVolume == 32 && !player.isCreative()) {
            return;
        }
        if ((Integer)state.getValue((Property)LeafLitterBlock.AMOUNT) > 1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)LeafLitterBlock.AMOUNT, (Comparable)Integer.valueOf((Integer)state.getValue((Property)LeafLitterBlock.AMOUNT) - 1)), 11);
        } else {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        }
        if (!level.isClientSide()) {
            level.levelEvent(2001, pos, Block.getId((BlockState)state));
        }
    }

    public void placeLeafLitterSegment(UseOnContext ctx, boolean firstPlacement) {
        BlockPlaceContext placeContext = new BlockPlaceContext(ctx);
        Player player = ctx.getPlayer();
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState state = level.getBlockState(pos);
        SoundType soundType = state.getSoundType();
        BlockPos relativePos = placeContext.getClickedPos();
        BlockState relativeBlock = level.getBlockState(relativePos);
        Direction direction = ctx.getHorizontalDirection().getOpposite();
        if (firstPlacement) {
            this.placeBlock(placeContext, (BlockState)this.leafLitter.setValue((Property)LeafLitterBlock.FACING, (Comparable)direction));
        } else {
            this.placeBlock(placeContext, (BlockState)relativeBlock.setValue((Property)LeafLitterBlock.AMOUNT, (Comparable)Integer.valueOf((Integer)relativeBlock.getValue((Property)LeafLitterBlock.AMOUNT) + 1)));
        }
        level.playSound((Entity)player, pos, this.getPlaceSound(state), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
        level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
    }
}

