/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.platform.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import net.minecraft.class_2960;

public class BidirectionalRegistryObject<K, V> {
    private final class_2960 id;
    private final BiMap<K, V> next;
    private final Map<V, K> previous;

    private BidirectionalRegistryObject(class_2960 identifier) {
        this.id = identifier;
        this.next = HashBiMap.create();
        this.previous = this.next.inverse();
    }

    public void register(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException("The value cannot be null.");
        }
        if (this.next.containsKey(key)) {
            throw new IllegalArgumentException("The key " + String.valueOf(key) + " is already registered.");
        }
        this.next.put(key, value);
    }

    public Optional<V> getNext(K key) {
        return Optional.ofNullable(this.next.get(key));
    }

    public Optional<K> getPrevious(V value) {
        return Optional.ofNullable(this.previous.get(value));
    }

    public Set<K> getKeySet() {
        return this.next.keySet();
    }

    public Set<V> getValueSet() {
        return this.next.values();
    }

    public int size() {
        return this.next.values().size();
    }

    public static <K, V> BidirectionalRegistryObject<K, V> create(class_2960 id) {
        return new BidirectionalRegistryObject<K, V>(id);
    }

    @Generated
    public class_2960 getId() {
        return this.id;
    }
}

