/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.block;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.seface.somemoreblocks.registries.SMBRegistries;
import org.jetbrains.annotations.NotNull;

public class WeatheringRotatedCopperFullBlock
extends RotatedPillarBlock
implements WeatheringCopper {
    private final WeatheringCopper.WeatherState weatherState;

    public WeatheringRotatedCopperFullBlock(WeatheringCopper.WeatherState weatherState, BlockBehaviour.Properties properties) {
        super(properties);
        this.weatherState = weatherState;
    }

    @NotNull
    public Optional<BlockState> getNext(BlockState state) {
        return SMBRegistries.WEATHERING_COPPER_BLOCKS.getNext(state.getBlock()).map(block -> block.withPropertiesOf(state)).or(() -> Optional.of(((Block)WeatheringCopper.getNext((Block)state.getBlock()).get()).defaultBlockState()));
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.changeOverTime(state, level, pos, random);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return SMBRegistries.WEATHERING_COPPER_BLOCKS.getNext(state.getBlock()).isPresent();
    }

    @NotNull
    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }
}

