/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.seface.somemoreblocks.block.LeafLitterBlock;
import net.seface.somemoreblocks.registries.SMBDataComponentTypes;
import org.jetbrains.annotations.NotNull;

public class LeavesBucketItem
extends SolidBucketItem {
    public static final int MAX_VOLUME = 16;
    public static final int MIN_VOLUME = 1;
    private static final int BAR_COLOR = 8418303;
    private final BlockState leafLitterState;

    public LeavesBucketItem(Block block, SoundEvent placeSound, Item.Properties properties) {
        super(block, placeSound, properties);
        ((LeafLitterBlock)block).setBucketItem((Item)this);
        this.leafLitterState = block.defaultBlockState();
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Player player = ctx.getPlayer();
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState state = level.getBlockState(pos);
        ItemStack stack = ctx.getItemInHand();
        int bucketVolume = (Integer)stack.getComponents().getOrDefault(this.getBucketVolumeComponentType(), (Object)1);
        if (state.getBlock().equals(this.getBlock())) {
            if (bucketVolume == 16 && !player.isCreative()) {
                return InteractionResult.FAIL;
            }
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
            if (!level.isClientSide()) {
                level.levelEvent(2001, pos, Block.getId((BlockState)state));
            }
            if (!player.isCreative() || bucketVolume < 16) {
                stack.set(this.getBucketVolumeComponentType(), (Object)(bucketVolume + 1));
            }
            return InteractionResult.SUCCESS;
        }
        if (bucketVolume > 0) {
            BlockPlaceContext placeContext = new BlockPlaceContext(ctx);
            BlockPos relativePos = placeContext.getClickedPos();
            BlockState relativeBlock = level.getBlockState(relativePos);
            if (!relativeBlock.canBeReplaced() || relativeBlock.is(this.leafLitterState.getBlock())) {
                return InteractionResult.FAIL;
            }
            if (!this.canPlace(placeContext, this.leafLitterState)) {
                return InteractionResult.FAIL;
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, stack);
            }
            this.placeBlock(placeContext, this.leafLitterState);
            SoundType soundType = state.getSoundType();
            level.playSound(player, pos, this.getPlaceSound(state), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
            level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
            if (player.isCreative()) {
                return InteractionResult.SUCCESS;
            }
            if (bucketVolume > 1) {
                stack.set(this.getBucketVolumeComponentType(), (Object)(bucketVolume - 1));
                return InteractionResult.SUCCESS;
            }
            player.setItemInHand(ctx.getHand(), BucketItem.getEmptySuccessItem((ItemStack)stack, (Player)player));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean isBarVisible(ItemStack stack) {
        return (Integer)stack.getComponents().getOrDefault(this.getBucketVolumeComponentType(), (Object)1) < 16;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.min(13 * (Integer)stack.getComponents().getOrDefault(this.getBucketVolumeComponentType(), (Object)1) / 16, 16);
    }

    public int getBarColor(ItemStack stack) {
        return 8418303;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, ctx, tooltip, tooltipFlag);
        int bucketVolume = (Integer)stack.getComponents().getOrDefault(this.getBucketVolumeComponentType(), (Object)1);
        tooltip.add(1, (Component)Component.translatable((String)"item.somemoreblocks.leaves_bucket.volume_description", (Object[])new Object[]{bucketVolume, 16}).withStyle(ChatFormatting.GRAY));
    }

    public DataComponentType<Integer> getBucketVolumeComponentType() {
        return (DataComponentType)SMBDataComponentTypes.BUCKET_VOLUME.get();
    }
}

