/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.seface.somemoreblocks.block.properties.QuadDirection;
import net.seface.somemoreblocks.registries.SMBBlockStateProperties;
import net.seface.somemoreblocks.registries.SMBBlocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigLilyPadBlock
extends WaterlilyBlock {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<QuadDirection> POSITION = SMBBlockStateProperties.POSITION;

    public BigLilyPadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(POSITION, (Comparable)((Object)QuadDirection.BOTTOM_LEFT))).setValue(FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter block, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> property) {
        property.add(new Property[]{POSITION, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Direction facing = context.getHorizontalDirection();
        BlockPos topLeftPos = pos.relative(facing);
        BlockPos topRightPos = pos.relative(facing.getClockWise()).relative(facing);
        BlockPos bottomRightPos = pos.relative(facing.getClockWise());
        boolean isPlaceable = level.getBlockState(pos).canBeReplaced(context) && level.getBlockState(topLeftPos).canBeReplaced(context) && level.getBlockState(topRightPos).canBeReplaced(context) && level.getBlockState(bottomRightPos).canBeReplaced(context);
        boolean isOnFluidOrIce = !(!level.getFluidState(pos.below()).is((Fluid)Fluids.WATER) && !level.getBlockState(pos.below()).is(Blocks.ICE) || !level.getFluidState(topLeftPos.below()).is((Fluid)Fluids.WATER) && !level.getBlockState(topLeftPos.below()).is(Blocks.ICE) || !level.getFluidState(topRightPos.below()).is((Fluid)Fluids.WATER) && !level.getBlockState(topRightPos.below()).is(Blocks.ICE) || !level.getFluidState(bottomRightPos.below()).is((Fluid)Fluids.WATER) && !level.getBlockState(bottomRightPos.below()).is(Blocks.ICE));
        return isPlaceable && isOnFluidOrIce ? super.getStateForPlacement(context) : null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity player, ItemStack item) {
        Direction facing = player != null ? player.getDirection() : Direction.getRandom((RandomSource)RandomSource.create());
        BlockPos topLeftPos = pos.relative(facing);
        BlockPos topRightPos = pos.relative(facing.getClockWise()).relative(facing);
        BlockPos bottomRightPos = pos.relative(facing.getClockWise());
        level.setBlock(pos, (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)facing), 3);
        level.setBlock(bottomRightPos, BigLilyPadBlock.createBlockStateFor(state, facing, QuadDirection.BOTTOM_RIGHT), 3);
        level.setBlock(topRightPos, BigLilyPadBlock.createBlockStateFor(state, facing, QuadDirection.TOP_RIGHT), 3);
        level.setBlock(topLeftPos, BigLilyPadBlock.createBlockStateFor(state, facing, QuadDirection.TOP_LEFT), 3);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos neighborBlockPos = this.getRelativeBlockPos(state, pos);
        QuadDirection expectedPosition = this.getExpectedNeighborPosition(state);
        BlockState neighborState = level.getBlockState(neighborBlockPos);
        if (state.getValue(POSITION) != QuadDirection.BOTTOM_LEFT) {
            return neighborState.is((Block)this) && neighborState.getValue(POSITION) == expectedPosition && super.canSurvive(state, level, pos);
        }
        return super.canSurvive(state, level, pos);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean bool) {
        BlockPos bottomLeftPos;
        Direction facing = (Direction)state.getValue(FACING);
        QuadDirection position = (QuadDirection)((Object)state.getValue(POSITION));
        if (position == QuadDirection.BOTTOM_RIGHT && level.getBlockState(bottomLeftPos = pos.relative(facing.getCounterClockWise())).is((Block)this)) {
            level.destroyBlock(bottomLeftPos, true);
            return;
        }
        super.onRemove(state, level, pos, newState, bool);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (level.isClientSide) {
            return super.playerWillDestroy(level, pos, state, player);
        }
        if (player.isCreative()) {
            this.preventDropFromBottomLeftPart(level, pos, state, player);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected void preventDropFromBottomLeftPart(Level level, BlockPos pos, BlockState state, Player player) {
        QuadDirection position = (QuadDirection)((Object)state.getValue(POSITION));
        if (position == QuadDirection.BOTTOM_LEFT) {
            return;
        }
        BlockPos bottomLeftPos = this.getRelativeBottomLeftBlockPos(state, pos);
        BlockState bottomLeft = level.getBlockState(bottomLeftPos);
        level.setBlock(bottomLeftPos, Blocks.STONE.defaultBlockState(), 35);
        if (bottomLeft.is((Block)this) && bottomLeft.getValue(POSITION) == QuadDirection.BOTTOM_LEFT) {
            BlockState newState = bottomLeft.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            level.setBlock(bottomLeftPos, newState, 35);
            level.levelEvent(player, 2001, bottomLeftPos, Block.getId((BlockState)bottomLeft));
        }
    }

    public static void placeAt(LevelAccessor level, Direction facing, BlockPos pos, int i) {
        BlockState bigLilyPad = ((Block)SMBBlocks.BIG_LILY_PAD.get()).defaultBlockState();
        BlockPos topLeftPos = pos.relative(facing);
        BlockPos topRightPos = pos.relative(facing.getClockWise()).relative(facing);
        BlockPos bottomRightPos = pos.relative(facing.getClockWise());
        level.setBlock(pos, (BlockState)bigLilyPad.setValue(FACING, (Comparable)facing), i);
        level.setBlock(bottomRightPos, BigLilyPadBlock.createBlockStateFor(bigLilyPad, facing, QuadDirection.BOTTOM_RIGHT), i);
        level.setBlock(topRightPos, BigLilyPadBlock.createBlockStateFor(bigLilyPad, facing, QuadDirection.TOP_RIGHT), i);
        level.setBlock(topLeftPos, BigLilyPadBlock.createBlockStateFor(bigLilyPad, facing, QuadDirection.TOP_LEFT), i);
    }

    private static BlockState createBlockStateFor(BlockState state, Direction facing, QuadDirection position) {
        return (BlockState)((BlockState)state.setValue(FACING, (Comparable)facing)).setValue(POSITION, (Comparable)((Object)position));
    }

    private BlockPos getRelativeBlockPos(BlockState state, BlockPos pos) {
        Direction facing = (Direction)state.getValue(FACING);
        QuadDirection position = (QuadDirection)((Object)state.getValue(POSITION));
        return switch (position) {
            default -> throw new IncompatibleClassChangeError();
            case QuadDirection.BOTTOM_LEFT -> pos.relative(facing.getClockWise());
            case QuadDirection.TOP_LEFT -> pos.relative(facing.getOpposite());
            case QuadDirection.TOP_RIGHT -> pos.relative(facing.getCounterClockWise());
            case QuadDirection.BOTTOM_RIGHT -> pos.relative(facing);
        };
    }

    private BlockPos getRelativeBottomLeftBlockPos(BlockState state, BlockPos pos) {
        Direction facing = (Direction)state.getValue(FACING);
        QuadDirection position = (QuadDirection)((Object)state.getValue(POSITION));
        return switch (position) {
            default -> throw new IncompatibleClassChangeError();
            case QuadDirection.TOP_LEFT -> pos.relative(facing.getOpposite());
            case QuadDirection.TOP_RIGHT -> pos.relative(facing.getCounterClockWise()).relative(facing.getOpposite());
            case QuadDirection.BOTTOM_LEFT -> pos;
            case QuadDirection.BOTTOM_RIGHT -> pos.relative(facing.getCounterClockWise());
        };
    }

    private QuadDirection getExpectedNeighborPosition(BlockState state) {
        QuadDirection position = (QuadDirection)((Object)state.getValue(POSITION));
        return switch (position) {
            default -> throw new IncompatibleClassChangeError();
            case QuadDirection.BOTTOM_LEFT -> QuadDirection.BOTTOM_RIGHT;
            case QuadDirection.TOP_LEFT -> QuadDirection.BOTTOM_LEFT;
            case QuadDirection.TOP_RIGHT -> QuadDirection.TOP_LEFT;
            case QuadDirection.BOTTOM_RIGHT -> QuadDirection.TOP_RIGHT;
        };
    }
}

