/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.seface.somemoreblocks.item.LeavesBucketItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ComposterBlock.class})
public abstract class ComposterBlockMixin
extends Block
implements WorldlyContainerHolder {
    public ComposterBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"use"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;awardStat(Lnet/minecraft/stats/Stat;)V")}, cancellable=true)
    private void useMixin(BlockState state, Level level, BlockPos pos$2, Player player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() instanceof LeavesBucketItem) {
            int levelState = (Integer)state.getValue((Property)ComposterBlock.LEVEL);
            int bucketVolume = LeavesBucketItem.getBucketVolume(stack);
            int missingLevels = 7 - levelState;
            bucketVolume -= Math.min(missingLevels, bucketVolume);
            if (!player.getAbilities().instabuild) {
                if (bucketVolume == 0) {
                    player.setItemInHand(hand, Items.BUCKET.getDefaultInstance());
                } else {
                    LeavesBucketItem.setBucketVolume(stack, bucketVolume);
                }
            }
            cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)level.isClientSide));
        }
    }

    @Inject(method={"addItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;setValue(Lnet/minecraft/world/level/block/state/properties/Property;Ljava/lang/Comparable;)Ljava/lang/Object;")}, cancellable=true)
    private static void addItemMixin(Entity entity, BlockState state, LevelAccessor level, BlockPos pos, ItemStack stack, CallbackInfoReturnable<BlockState> cir) {
        if (stack.getItem() instanceof LeavesBucketItem) {
            int levelState = (Integer)state.getValue((Property)ComposterBlock.LEVEL);
            int bucketVolume = LeavesBucketItem.getBucketVolume(stack);
            int missingLevels = 7 - levelState;
            BlockState state2 = (BlockState)state.setValue((Property)ComposterBlock.LEVEL, (Comparable)Integer.valueOf(levelState += Math.min(missingLevels, bucketVolume)));
            level.setBlock(pos, state2, 3);
            level.gameEvent(GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)state2));
            cir.setReturnValue((Object)state);
        }
    }
}

