/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.client.config.AdvancementToastScreenBehavior;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementSetup;
import net.bivrik.fancytoasts.client.toast.texture.TextureUV;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.GUIs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public abstract class FancyAdvancementToastAnimation {
    protected FancyAdvancementSetup setup;
    protected FancyAdvancementToast toast;
    private int guiColor = -1;
    private float guiAlpha;

    public void setup(FancyAdvancementSetup setup, FancyAdvancementToast toast) {
        this.setup = setup;
        this.toast = toast;
    }

    public void draw(GuiGraphics guiGraphics, Minecraft minecraft, long time) {
        this.guiAlpha = Common.getAdvancementToastManager().isScreenOpened() && Common.getConfigManager().getGeneralConfig().getScreenBehavior() == AdvancementToastScreenBehavior.TRANSPARENT ? 0.5f : 1.0f;
        this.guiColor = Colors.alpha((int)(this.guiAlpha * 255.0f), -1);
    }

    public abstract int getDuration();

    public abstract int getToastSoundTiming();

    protected void drawIcon(GuiGraphics graphics, float alpha) {
        TextureUV frameUV = this.setup.uvs().frame();
        GUIs.drawTexture(graphics, this.setup.texture(), 68, 0, frameUV.u(), frameUV.v(), 26, 26, Colors.alpha((int)(alpha * this.guiAlpha * 255.0f), this.guiColor));
        graphics.renderFakeItem(this.setup.display().getIcon(), 73, 5);
    }

    protected void drawIcon(GuiGraphics guiGraphics) {
        this.drawIcon(guiGraphics, 1.0f);
    }

    protected void drawBanner(GuiGraphics graphics, float alpha) {
        TextureUV bannerUV = this.setup.uvs().banner();
        GUIs.drawTexture(graphics, this.setup.texture(), 0, 5, bannerUV.u(), bannerUV.v(), 162, 14, Colors.alpha((int)(alpha * this.guiAlpha * 255.0f), this.guiColor));
    }

    protected void drawBanner(GuiGraphics graphics) {
        this.drawBanner(graphics, 1.0f);
    }

    protected void drawBackground(GuiGraphics graphics, float alpha) {
        GUIs.drawTexture(graphics, this.setup.texture(), 0, 20, 0, 0, 162, 40, Colors.alpha((int)(alpha * this.guiAlpha * 255.0f), this.guiColor));
        GUIs.drawTexture(graphics, this.setup.texture(), 144, 56, 0, 108, 9, 14, Colors.alpha((int)(alpha * this.guiAlpha * 255.0f), this.guiColor));
    }

    protected void drawBackground(GuiGraphics graphics) {
        this.drawBackground(graphics, 1.0f);
    }
}

