/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.config;

import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.EnumMap;
import java.util.Map;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.config.ConfigData;
import net.bivrik.fancytoasts.client.config.ConfigTextureManager;
import net.bivrik.fancytoasts.client.toast.ToastAnimationRegistry;
import net.bivrik.fancytoasts.client.toast.ToastTextureRegistry;
import net.bivrik.fancytoasts.utility.DefaultLocations;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public class ToastConfigData
extends ConfigData {
    private ResourceLocation animationId;
    private ResourceLocation textureId;
    private final Map<AdvancementType, ResourceLocation> soundIds = new EnumMap<AdvancementType, ResourceLocation>(AdvancementType.class);

    public ToastConfigData(ResourceLocation animationId, ResourceLocation textureId, Map<AdvancementType, ResourceLocation> soundIds) {
        super("./config/fancytoasts/toast.json");
        this.animationId = animationId;
        this.textureId = textureId;
        this.soundIds.putAll(soundIds);
    }

    public ToastConfigData() {
        super("./config/fancytoasts/toast.json");
        this.animationId = DefaultLocations.Animations.STANDARD;
        this.textureId = DefaultLocations.Textures.VANILLA;
        this.soundIds.putAll(Map.of(AdvancementType.TASK, SoundEvents.ALLAY_AMBIENT_WITH_ITEM.location(), AdvancementType.GOAL, SoundEvents.FIREWORK_ROCKET_TWINKLE_FAR.location(), AdvancementType.CHALLENGE, SoundEvents.UI_TOAST_CHALLENGE_COMPLETE.location()));
    }

    public ResourceLocation getAnimationId() {
        return this.animationId;
    }

    public void setAnimationId(ResourceLocation id) {
        this.animationId = id;
    }

    public ResourceLocation getTextureId() {
        return this.textureId;
    }

    public void setTextureId(ResourceLocation id) {
        this.textureId = id;
    }

    public ResourceLocation getSoundId(AdvancementType type) {
        SoundManager soundManager = Minecraft.getInstance().getSoundManager();
        if (!soundManager.getAvailableSounds().contains(this.soundIds.get(type))) {
            Debug.warn("Saved sounds are invalid. Used standard ones");
            AdvancementType advancementType = type;
            int n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TASK", "GOAL"}, (AdvancementType)advancementType, n)) {
                case 0: {
                    return SoundEvents.ALLAY_AMBIENT_WITH_ITEM.location();
                }
                case 1: {
                    return SoundEvents.FIREWORK_ROCKET_TWINKLE_FAR.location();
                }
            }
            return SoundEvents.UI_TOAST_CHALLENGE_COMPLETE.location();
        }
        return this.soundIds.get(type);
    }

    public void putSound(AdvancementType type, ResourceLocation location) {
        this.soundIds.put(type, location);
    }

    @Override
    public String getPath() {
        File oldPathConfigFile = new File("./config/fancytoasts/standard.json");
        oldPathConfigFile.delete();
        return super.getPath();
    }

    @Override
    public boolean isValid() {
        if (ToastTextureRegistry.isRegistered(this.textureId)) {
            if (this.textureId.toLanguageKey().contains("config")) {
                ConfigTextureManager.registerInMinecraft(this.textureId);
            }
        } else {
            return false;
        }
        return ToastAnimationRegistry.isRegistered(this.animationId);
    }

    @Override
    public ToastConfigData get() {
        return new ToastConfigData(this.animationId, this.textureId, this.soundIds);
    }

    @Override
    public String toString() {
        return super.toString().replace("}", ", ") + String.format("animationId='%s', textureId='%s', soundIds='%s'}", this.animationId, this.textureId, this.soundIds);
    }
}

