/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.ui.ResourceLocationFilter;
import net.bivrik.fancytoasts.client.ui.SettingType;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class ResourceLocationList
extends class_4280<Entry> {
    private class_2960[] resourceLocations;
    private SettingType settingType;
    private Consumer<class_2960> acceptResponder;
    private Consumer<class_2960> selectResponder;

    public ResourceLocationList(class_310 minecraft, int width, int height, int x, int y, int itemHeight, SettingType settingType) {
        super(minecraft, width, height, y, itemHeight);
        this.method_46421(x);
        this.setResourceLocations(settingType);
    }

    public void setAcceptResponder(Consumer<class_2960> acceptResponder) {
        this.acceptResponder = acceptResponder;
    }

    public void setSelectResponder(Consumer<class_2960> selectResponder) {
        this.selectResponder = selectResponder;
    }

    public int method_25322() {
        return this.field_22758 - 6 - 16;
    }

    public int method_25342() {
        return this.method_46426() + this.field_22758 / 2 - this.method_25322() / 2 - 3;
    }

    protected int method_65507() {
        return this.method_46426() + this.field_22758 - 8;
    }

    public void onSearchUpdate(String search) {
        this.clear();
        search = search.toLowerCase(Locale.ROOT);
        for (class_2960 location : this.resourceLocations) {
            if (!this.settingType.getDisplayData(location).getName().getString().toLowerCase(Locale.ROOT).contains(search)) continue;
            this.method_25321((class_350.class_351)new ResourceLocationListEntry(this, location, this.settingType.getDisplayData(location).getName()));
        }
    }

    public void onFilterUpdate(ResourceLocationFilter filter) {
        switch (filter) {
            case A_Z: {
                this.sortAZ();
                break;
            }
            case Z_A: {
                Arrays.sort(this.resourceLocations, (loc1, loc2) -> {
                    String name1 = this.settingType.getDisplayData((class_2960)loc1).getName().getString();
                    String name2 = this.settingType.getDisplayData((class_2960)loc2).getName().getString();
                    return name2.compareTo(name1);
                });
                break;
            }
            case BUILT_IN: {
                this.resourceLocations = this.typeSort(this.resourceLocations, true);
                break;
            }
            case CUSTOM: {
                this.resourceLocations = this.typeSort(this.resourceLocations, false);
            }
        }
        this.refillList();
    }

    private void sortAZ() {
        Arrays.sort(this.resourceLocations, (loc1, loc2) -> {
            String name1 = this.settingType.getDisplayData((class_2960)loc1).getName().getString();
            String name2 = this.settingType.getDisplayData((class_2960)loc2).getName().getString();
            return name1.compareTo(name2);
        });
    }

    private class_2960[] typeSort(class_2960[] locations, boolean isBuiltInSortType) {
        this.sortAZ();
        ArrayList<Object> sorted = new ArrayList<Object>(locations.length / 2);
        ArrayList<class_2960> leftovers = new ArrayList<class_2960>();
        for (class_2960 location : locations) {
            boolean isCustom;
            boolean isBuiltIn = location.method_12836().equals("fancytoasts") || location.method_12836().equals("minecraft");
            boolean isConfig = location.method_42094().contains("config");
            boolean bl = isCustom = !isBuiltIn || isConfig;
            if (isBuiltInSortType != isCustom) {
                sorted.add(location);
                continue;
            }
            leftovers.add(location);
        }
        sorted.addAll(leftovers);
        return sorted.toArray(new class_2960[0]);
    }

    public void setResourceLocations(SettingType settingType) {
        this.settingType = settingType;
        this.resourceLocations = this.settingType.getKeySet();
        Arrays.sort(this.resourceLocations);
        this.refillList();
    }

    private void refillList() {
        this.clear();
        for (class_2960 location : this.resourceLocations) {
            this.method_25321((class_350.class_351)new ResourceLocationListEntry(this, location, this.settingType.getDisplayData(location).getName()));
        }
    }

    private void clear() {
        this.method_25339();
        this.method_65506();
    }

    private static final class ResourceLocationListEntry
    extends Entry {
        private final class_2960 location;
        private final class_310 minecraft;
        private final class_327 font;
        private final ResourceLocationList list;
        private final List<class_5481> nameList;
        private final boolean isConfig;
        private long lastClickTime;

        public ResourceLocationListEntry(ResourceLocationList list, class_2960 location, class_2561 name) {
            this.list = list;
            this.location = location;
            this.minecraft = this.list.field_22740;
            this.font = this.minecraft.field_1772;
            this.isConfig = location.method_42094().contains("config");
            this.nameList = this.font.method_1728((class_5348)name, this.list.method_25322() - 8 - 2);
        }

        public boolean method_25402(class_11909 e, boolean isDoubleClick) {
            if (class_156.method_658() - this.lastClickTime >= 250L) {
                this.lastClickTime = class_156.method_658();
                this.select();
            } else {
                this.accept();
            }
            return super.method_25402(e, isDoubleClick);
        }

        public boolean method_25404(class_11908 e) {
            if (e.method_74229()) {
                this.accept();
            }
            return super.method_25404(e);
        }

        private void select() {
            if (this.list.selectResponder != null) {
                this.list.selectResponder.accept(this.location);
            } else {
                Debug.error("There is no select responder for Resource Location List. Could not select location: " + String.valueOf(this.location));
            }
        }

        private void accept() {
            if (this.list.acceptResponder != null) {
                this.list.acceptResponder.accept(this.location);
                this.minecraft.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            } else {
                Debug.error("There is no accept responder for Resource Location List. Could not accept location: " + String.valueOf(this.location));
            }
        }

        public int method_46426() {
            return super.method_46426() - 3;
        }

        public int method_25368() {
            return super.method_25368() + 3;
        }

        public void method_25343(@NotNull class_332 guiGraphics, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            int secondColor;
            int mainColor;
            int x = this.method_46426();
            int y = this.method_46427();
            if (this.method_25370()) {
                mainColor = -256;
                secondColor = -377606;
            } else {
                if (isHovering) {
                    guiGraphics.method_25294(x, y, x + this.method_25368(), y + this.method_25364(), Colors.alpha(32, -1));
                    guiGraphics.method_25294(x + 1, y + 1, x + this.method_25368() - 1, y + this.method_25364() - 1, Colors.alpha(128, 0));
                }
                mainColor = -1;
                secondColor = -6250336;
            }
            if (this.nameList.size() == 1) {
                guiGraphics.method_35720(this.font, this.nameList.getFirst(), x + 3, y + 5, mainColor);
            } else {
                guiGraphics.method_35720(this.font, this.nameList.get(1), x + 3, y + 8, secondColor);
                guiGraphics.method_35720(this.font, this.nameList.get(0), x + 3, y + 2, mainColor);
            }
            if (this.isConfig) {
                guiGraphics.method_27535(this.font, (class_2561)class_2561.method_43470((String)"c"), this.method_46426() + this.method_25368() - 10, y + 5, -6250336);
            }
        }
    }

    protected static abstract class Entry
    extends class_4280.class_4281<Entry> {
        protected Entry() {
        }

        @NotNull
        public class_2561 method_37006() {
            return class_2561.method_43473();
        }
    }
}

