/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.config;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.config.JsonHelper;
import net.bivrik.fancytoasts.client.toast.registry.ToastTextureRegistry;
import net.bivrik.fancytoasts.client.toast.texture.DisplayData;
import net.bivrik.fancytoasts.client.util.FileHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class ConfigTextureManager {
    private static final Map<ResourceLocation, Path> CONFIG_TEXTURES = new HashMap<ResourceLocation, Path>();
    private static final File TEXTURES_DIR = new File("./config/fancytoasts/textures/");
    private static final FileFilter TEXTURE_FILES_FILTER = file -> {
        String name = file.getName();
        return name.endsWith(".png") || name.endsWith(".json");
    };

    public static void registerInMinecraft(ResourceLocation id) {
        if (!ToastTextureRegistry.isRegistered(id)) {
            Debug.error("Could not register texture {} in minecraft texture manager", id);
            return;
        }
        try {
            NativeImage image = NativeImage.read((byte[])Files.readAllBytes(CONFIG_TEXTURES.get(id)));
            DynamicTexture dynamicTexture = new DynamicTexture(image);
            Minecraft.getInstance().getTextureManager().register(id, (AbstractTexture)dynamicTexture);
            image.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void unregisterFromMinecraft() {
        for (ResourceLocation id : CONFIG_TEXTURES.keySet()) {
            Minecraft.getInstance().getTextureManager().release(id);
        }
    }

    public static void reload() {
        ConfigTextureManager.unregisterFromMinecraft();
        CONFIG_TEXTURES.clear();
        ToastTextureRegistry.clearCustom();
        ConfigTextureManager.load();
    }

    public static void load() {
        if (FileHelper.tryCreateDir(TEXTURES_DIR)) {
            return;
        }
        File[] files = TEXTURES_DIR.listFiles(TEXTURE_FILES_FILTER);
        if (files == null) {
            Debug.warn("There are no files in the config texture directory");
            return;
        }
        int initialCap = files.length / 2;
        ArrayList<File> textureFiles = new ArrayList<File>(initialCap);
        ArrayList<File> jsonFiles = new ArrayList<File>(initialCap);
        for (File file : files) {
            String fileName = file.getName();
            if (fileName.endsWith(".png")) {
                textureFiles.add(file);
                continue;
            }
            if (!fileName.endsWith(".json")) continue;
            jsonFiles.add(file);
        }
        ConfigTextureManager.register(jsonFiles, textureFiles);
    }

    private static void register(List<File> jsonFiles, List<File> textureFiles) {
        for (File jsonFile : jsonFiles) {
            for (File textureFile : textureFiles) {
                if (FileHelper.getRawName(textureFile).compareTo(FileHelper.getRawName(jsonFile)) != 0) continue;
                Optional<DisplayData> optionalData = JsonHelper.tryToRead(jsonFile, DisplayData.class);
                if (optionalData.isPresent()) {
                    DisplayData data = optionalData.get();
                    ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"fancytoasts", (String)textureFile.getPath().replace("\\", "/").replaceFirst("./", ""));
                    if (!ToastTextureRegistry.register(id, null, data.getName().getString(), data.getAuthor().getString(), data.getDescription().getString())) continue;
                    CONFIG_TEXTURES.put(id, textureFile.toPath());
                    continue;
                }
                Debug.error("Texture data is outdated or corrupted! File: {}", jsonFile.getAbsolutePath());
            }
        }
    }
}

