/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.client.config.ConfigHandler;
import net.bivrik.fancytoasts.client.config.GeneralConfigData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class GeneralConfigScreen
extends Screen {
    private final Screen parent;
    private final GeneralConfigData generalConfigData;
    private Button doneButton;
    private Button backButton;
    private CycleButton<Boolean> jadeCompatCycleButton;
    private CycleButton<Boolean> soundsEnabledCycleButton;
    private VolumeSlider taskVolumeSlider;
    private VolumeSlider goalVolumeSlider;
    private VolumeSlider challengeVolumeSlider;
    private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();

    public GeneralConfigScreen(Component title, Screen parent) {
        super(title);
        this.parent = parent;
        this.generalConfigData = Common.getConfigManager().getGeneralConfig();
    }

    private <T extends AbstractWidget> T addWidget(T aw) {
        this.widgets.add(aw);
        return aw;
    }

    protected void init() {
        this.jadeCompatCycleButton = CycleButton.onOffBuilder().withInitialValue((Object)this.generalConfigData.isJadeCompatEnabled()).withTooltip(value -> Tooltip.create((Component)Component.translatable((String)"fancytoasts.gui.tooltip.jade_compatibility"))).create(0, 0, 150, 20, (Component)Component.translatable((String)"fancytoasts.gui.label.jade_compatibility"), (button, value) -> this.generalConfigData.setJadeCompatEnabled((boolean)value));
        this.soundsEnabledCycleButton = CycleButton.onOffBuilder().withInitialValue((Object)this.generalConfigData.areSoundsEnabled()).withTooltip(value -> Tooltip.create((Component)Component.translatable((String)"fancytoasts.gui.tooltip.sounds_enabled"))).create(0, 0, 150, 20, (Component)Component.translatable((String)"fancytoasts.gui.label.sounds_enabled"), (button, value) -> this.generalConfigData.setSoundsEnabled((boolean)value));
        this.taskVolumeSlider = new VolumeSlider(0, 0, 150, 20, (Component)Component.translatable((String)"fancytoasts.gui.label.task_volume"), this.generalConfigData.getTaskVolume());
        this.taskVolumeSlider.setResponder(this.generalConfigData::setTaskVolume);
        this.goalVolumeSlider = new VolumeSlider(0, 0, 150, 20, (Component)Component.translatable((String)"fancytoasts.gui.label.goal_volume"), this.generalConfigData.getGoalVolume());
        this.goalVolumeSlider.setResponder(this.generalConfigData::setGoalVolume);
        this.challengeVolumeSlider = new VolumeSlider(0, 0, 150, 20, (Component)Component.translatable((String)"fancytoasts.gui.label.challenge_volume"), this.generalConfigData.getChallengeVolume());
        this.challengeVolumeSlider.setResponder(this.generalConfigData::setChallengeVolume);
        this.renderWidgets();
        this.doneButton = this.addWidget(Button.builder((Component)CommonComponents.GUI_DONE, button -> this.done()).bounds(this.width / 2 + 100 - 125 + 4, this.height - 26, 150, 20).build());
        this.backButton = this.addWidget(Button.builder((Component)CommonComponents.GUI_BACK, button -> this.toParentScreen()).bounds(this.width / 2 - 125 - 4, this.height - 20 - 6, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)this.doneButton);
        this.addRenderableWidget((GuiEventListener)this.backButton);
    }

    protected void rebuildWidgets() {
        this.widgets.clear();
        super.rebuildWidgets();
    }

    private void renderWidgets() {
        this.addWidget((AbstractWidget)this.jadeCompatCycleButton);
        this.addWidget((AbstractWidget)this.soundsEnabledCycleButton);
        this.addWidget(this.taskVolumeSlider);
        this.addWidget(this.goalVolumeSlider);
        this.addWidget(this.challengeVolumeSlider);
        int y = 40;
        for (int i = 0; i < this.widgets.size(); ++i) {
            int x = this.width / 2 - 150 - 4;
            if ((i & 1) == 0) {
                if (i != 0) {
                    y += 28;
                }
            } else {
                x += 158;
            }
            AbstractWidget widget = this.widgets.get(i);
            widget.setX(x);
            widget.setY(y);
            this.addRenderableWidget((GuiEventListener)widget);
        }
    }

    private void done() {
        ConfigHandler.save(this.generalConfigData);
        this.toParentScreen();
    }

    private void toParentScreen() {
        Objects.requireNonNull(this.minecraft).setScreen(this.parent);
    }

    public void onClose() {
        this.toParentScreen();
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        RenderSystem.enableBlend();
        ResourceLocation resourcelocation = ResourceLocation.withDefaultNamespace((String)"textures/gui/menu_list_background.png");
        graphics.blit(resourcelocation, 0, 32, 0.0f, 0.0f, this.width, this.height - 64 - 2, 32, 32);
        graphics.blit(Screen.HEADER_SEPARATOR, 0, 32, 0.0f, 0.0f, this.width, 2, 32, 2);
        graphics.blit(Screen.FOOTER_SEPARATOR, 0, this.height - 32 - 2, 0.0f, 0.0f, this.width, 2, 32, 2);
        RenderSystem.disableBlend();
        for (AbstractWidget widget : this.widgets) {
            widget.render(graphics, mouseX, mouseY, partialTick);
        }
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 12, -1);
    }

    private static class VolumeSlider
    extends AbstractSliderButton {
        private Consumer<Float> responder;
        private Component message;

        public VolumeSlider(int x, int y, int width, int height, Component message, double value) {
            super(x, y, width, height, (Component)Component.empty(), value / 2.0);
            this.message = message;
            this.updateMessage();
        }

        public void setResponder(Consumer<Float> responder) {
            this.responder = responder;
        }

        protected void updateMessage() {
            this.setMessage((Component)CommonComponents.optionNameValue((Component)this.message, (Component)Component.literal((String)(Math.round(this.getVolume() * 100.0f) + "%"))));
        }

        private float getVolume() {
            return (float)Math.round(Mth.lerp((double)this.value, (double)0.0, (double)2.0) * 10.0) / 10.0f;
        }

        protected void applyValue() {
            this.responder.accept(Float.valueOf(this.getVolume()));
        }
    }
}

