/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.gui.SettingType;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class ResourceLocationList
extends ObjectSelectionList<Entry> {
    private ResourceLocation[] resourceLocations;
    private SettingType settingType;
    private Consumer<ResourceLocation> acceptResponder;
    private Consumer<ResourceLocation> selectResponder;

    public ResourceLocationList(Minecraft minecraft, int width, int height, int x, int y, int itemHeight, SettingType settingType) {
        super(minecraft, width, height, y, itemHeight);
        this.setX(x);
        this.setResourceLocations(settingType);
    }

    public void setAcceptResponder(Consumer<ResourceLocation> acceptResponder) {
        this.acceptResponder = acceptResponder;
    }

    public void setSelectResponder(Consumer<ResourceLocation> selectResponder) {
        this.selectResponder = selectResponder;
    }

    public int getRowWidth() {
        return this.width - 6 - 16;
    }

    public int getRowLeft() {
        return this.getX() + this.width / 2 - this.getRowWidth() / 2 + 4;
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.width - 8;
    }

    public void onFilterUpdate(String filter) {
        this.clear();
        filter = filter.toLowerCase(Locale.ROOT);
        for (ResourceLocation location : this.resourceLocations) {
            if (!this.settingType.getDisplayData(location).getName().getString().toLowerCase(Locale.ROOT).contains(filter)) continue;
            this.addEntry((AbstractSelectionList.Entry)new ResourceLocationListEntry(this, location, this.settingType.getDisplayData(location).getName()));
        }
    }

    public void setResourceLocations(SettingType settingType) {
        this.settingType = settingType;
        this.resourceLocations = this.settingType.getKeySet();
        this.refillList();
    }

    private void refillList() {
        this.clear();
        for (ResourceLocation location : this.resourceLocations) {
            this.addEntry((AbstractSelectionList.Entry)new ResourceLocationListEntry(this, location, this.settingType.getDisplayData(location).getName()));
        }
    }

    private void clear() {
        this.clearEntries();
        this.setScrollAmount(0.0);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Entry selectedEntry;
        if (CommonInputs.selected((int)keyCode) && (selectedEntry = (Entry)this.getSelected()) instanceof ResourceLocationListEntry) {
            ((ResourceLocationListEntry)selectedEntry).accept();
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private static final class ResourceLocationListEntry
    extends Entry {
        private final ResourceLocation location;
        private final Minecraft minecraft;
        private final Font font;
        private final ResourceLocationList list;
        private final List<FormattedCharSequence> nameList;
        private long lastClickTime;

        public ResourceLocationListEntry(ResourceLocationList list, ResourceLocation location, Component name) {
            this.list = list;
            this.location = location;
            this.minecraft = this.list.minecraft;
            this.font = this.minecraft.font;
            this.nameList = this.font.split((FormattedText)name, this.list.getRowWidth() - 8 - 2);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (Util.getMillis() - this.lastClickTime >= 250L) {
                this.lastClickTime = Util.getMillis();
                this.select();
            } else {
                this.accept();
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        private void select() {
            if (this.list.selectResponder != null) {
                this.list.selectResponder.accept(this.location);
            } else {
                Debug.error("There is no select responder for Resource Location List. Could not select location: " + String.valueOf(this.location));
            }
        }

        private void accept() {
            if (this.list.acceptResponder != null) {
                this.list.acceptResponder.accept(this.location);
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            } else {
                Debug.error("There is no accept responder for Resource Location List. Could not accept location: " + String.valueOf(this.location));
            }
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (this.nameList.size() == 1) {
                guiGraphics.drawString(this.font, this.nameList.getFirst(), x, y + 3, -1);
            } else {
                guiGraphics.drawString(this.font, this.nameList.get(1), x, y + 6, -6250336);
                guiGraphics.drawString(this.font, this.nameList.get(0), x, y, -1);
            }
        }
    }

    protected static abstract class Entry
    extends ObjectSelectionList.Entry<Entry> {
        protected Entry() {
        }

        @NotNull
        public Component getNarration() {
            return Component.empty();
        }
    }
}

